/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.internal;

import java.math.BigInteger;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;

public interface Words {
    public static UInt256 fromAddress(Address address) {
        return UInt256.fromBytes((Bytes)Bytes32.leftPad((Bytes)address));
    }

    public static Address toAddress(Bytes bytes) {
        int size = bytes.size();
        if (size < 20) {
            MutableBytes result = MutableBytes.create((int)20);
            bytes.copyTo(result, 20 - size);
            return Address.wrap((Bytes)result.copy());
        }
        if (size == 20) {
            return Address.wrap((Bytes)bytes);
        }
        return Address.wrap((Bytes)bytes.slice(size - 20, 20));
    }

    public static int numWords(Bytes input) {
        return (input.size() + 32 - 1) / 32;
    }

    public static int numWords(int length) {
        return (length + 32 - 1) / 32;
    }

    public static long clampedToLong(Bytes uint) {
        if (uint.size() <= 8) {
            long result = uint.toLong();
            return result < 0L ? Long.MAX_VALUE : result;
        }
        Bytes trimmed = uint.trimLeadingZeros();
        if (trimmed.size() <= 8) {
            long result = trimmed.toLong();
            return result < 0L ? Long.MAX_VALUE : result;
        }
        return Long.MAX_VALUE;
    }

    public static int clampedToInt(Bytes uint) {
        if (uint.size() <= 4) {
            int result = uint.toInt();
            return result < 0 ? Integer.MAX_VALUE : result;
        }
        Bytes trimmed = uint.trimLeadingZeros();
        if (trimmed.size() <= 4) {
            int result = trimmed.toInt();
            return result < 0 ? Integer.MAX_VALUE : result;
        }
        return Integer.MAX_VALUE;
    }

    public static int clampedToInt(long l) {
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }

    public static long clampedAdd(long a, long b) {
        long r = a + b;
        if (((a ^ r) & (b ^ r)) < 0L) {
            return a > 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return r;
    }

    public static long clampedMultiply(long a, long b) {
        long ay;
        long r = a * b;
        long ax = Math.abs(a);
        if ((ax | (ay = Math.abs(b))) >>> 31 != 0L && (b != 0L && r / b != a || a == Long.MIN_VALUE && b == -1L)) {
            return (a ^ b) < 0L ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        return r;
    }

    public static long unsignedMin(long a, long b) {
        return Long.compareUnsigned(a, b) < 0 ? a : b;
    }

    public static int readBigEndianU16(int index, byte[] array) {
        if (index + 1 >= array.length) {
            throw new IndexOutOfBoundsException();
        }
        return array[index] << 8 & 0xFF00 | array[index + 1] & 0xFF;
    }

    public static int readBigEndianI16(int index, byte[] array) {
        if (index + 1 >= array.length) {
            throw new IndexOutOfBoundsException();
        }
        return array[index] << 8 | array[index + 1] & 0xFF;
    }

    public static Bytes intBytes(int value) {
        return Bytes.of((byte[])new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value});
    }

    public static Bytes longBytes(long value) {
        return Bytes.of((byte[])new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value});
    }

    public static long decodeUnsignedLong(String number) {
        String parsable = number;
        int radix = 10;
        if (number.startsWith("0x")) {
            radix = 16;
            parsable = number.substring(2);
        } else if (!number.matches("\\d+")) {
            radix = 16;
        }
        BigInteger bi = new BigInteger(parsable, radix);
        if (bi.bitCount() > 64) {
            throw new NumberFormatException("Number larger than uint64");
        }
        return bi.longValue();
    }
}

