/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.precompile;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.hyperledger.besu.crypto.altbn128.AltBn128Point;
import org.hyperledger.besu.crypto.altbn128.Fq;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.precompile.AbstractAltBnPrecompiledContract;
import org.hyperledger.besu.evm.precompile.PrecompiledContract;

public class AltBN128MulPrecompiledContract
extends AbstractAltBnPrecompiledContract {
    private static final int PARAMETER_LENGTH = 96;
    private static final BigInteger MAX_N = new BigInteger("115792089237316195423570985008687907853269984665640564039457584007913129639935");
    private static final Bytes POINT_AT_INFINITY = Bytes.repeat((byte)0, (int)64);
    private final long gasCost;

    private AltBN128MulPrecompiledContract(GasCalculator gasCalculator, long gasCost) {
        super("AltBN128Mul", gasCalculator, (byte)2, 96);
        this.gasCost = gasCost;
    }

    public static AltBN128MulPrecompiledContract byzantium(GasCalculator gasCalculator) {
        return new AltBN128MulPrecompiledContract(gasCalculator, 40000L);
    }

    public static AltBN128MulPrecompiledContract istanbul(GasCalculator gasCalculator) {
        return new AltBN128MulPrecompiledContract(gasCalculator, 6000L);
    }

    @Override
    public long gasRequirement(Bytes input) {
        return this.gasCost;
    }

    @Override
    @Nonnull
    public PrecompiledContract.PrecompileContractResult computePrecompile(Bytes input, @Nonnull MessageFrame messageFrame) {
        if (input.size() >= 64 && input.slice(0, 64).equals((Object)POINT_AT_INFINITY)) {
            return new PrecompiledContract.PrecompileContractResult(POINT_AT_INFINITY, false, MessageFrame.State.COMPLETED_SUCCESS, Optional.empty());
        }
        if (useNative) {
            return this.computeNative(input, messageFrame);
        }
        return AltBN128MulPrecompiledContract.computeDefault(input);
    }

    @Nonnull
    private static PrecompiledContract.PrecompileContractResult computeDefault(Bytes input) {
        BigInteger x = AltBN128MulPrecompiledContract.extractParameter(input, 0, 32);
        BigInteger y = AltBN128MulPrecompiledContract.extractParameter(input, 32, 32);
        BigInteger n = AltBN128MulPrecompiledContract.extractParameter(input, 64, 32);
        AltBn128Point p = new AltBn128Point(Fq.create((BigInteger)x), Fq.create((BigInteger)y));
        if (!p.isOnCurve() || n.compareTo(MAX_N) > 0) {
            return PrecompiledContract.PrecompileContractResult.halt(null, Optional.of(ExceptionalHaltReason.PRECOMPILE_ERROR));
        }
        AltBn128Point product = (AltBn128Point)p.multiply(n);
        Bytes xResult = product.getX().toBytes();
        Bytes yResult = product.getY().toBytes();
        MutableBytes result = MutableBytes.create((int)64);
        xResult.copyTo(result, 32 - xResult.size());
        yResult.copyTo(result, 64 - yResult.size());
        return PrecompiledContract.PrecompileContractResult.success((Bytes)result);
    }

    private static BigInteger extractParameter(Bytes input, int offset, int length) {
        if (offset > input.size() || length == 0) {
            return BigInteger.ZERO;
        }
        byte[] raw = Arrays.copyOfRange(input.toArrayUnsafe(), offset, offset + length);
        return new BigInteger(1, raw);
    }
}

