/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.precompile;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;

public interface PrecompiledContract {
    public String getName();

    public long gasRequirement(Bytes var1);

    @Nonnull
    default public PrecompileContractResult computePrecompile(Bytes input, @Nonnull MessageFrame messageFrame) {
        Bytes result = this.compute(input, messageFrame);
        if (result == null) {
            return PrecompileContractResult.halt(null, Optional.of(ExceptionalHaltReason.NONE));
        }
        return PrecompileContractResult.success(result);
    }

    @Deprecated(since="22.1.2")
    default public Bytes compute(Bytes input, @Nonnull MessageFrame messageFrame) {
        return this.computePrecompile(input, messageFrame).getOutput();
    }

    public static class PrecompileContractResult {
        private final Bytes output;
        private final boolean refundGas;
        private final MessageFrame.State state;
        private final Optional<ExceptionalHaltReason> haltReason;

        public PrecompileContractResult(Bytes output, boolean refundGas, MessageFrame.State state, Optional<ExceptionalHaltReason> haltReason) {
            this.output = output;
            this.refundGas = refundGas;
            this.state = state;
            this.haltReason = haltReason;
        }

        public static PrecompileContractResult success(Bytes output) {
            return new PrecompileContractResult(output, false, MessageFrame.State.COMPLETED_SUCCESS, Optional.empty());
        }

        public static PrecompileContractResult revert(Bytes output) {
            return new PrecompileContractResult(output, false, MessageFrame.State.REVERT, Optional.empty());
        }

        public static PrecompileContractResult halt(Bytes output, Optional<ExceptionalHaltReason> haltReason) {
            if (haltReason.isEmpty()) {
                throw new IllegalArgumentException("Halt reason cannot be empty");
            }
            return new PrecompileContractResult(output, false, MessageFrame.State.EXCEPTIONAL_HALT, haltReason);
        }

        public Bytes getOutput() {
            return this.output;
        }

        public boolean isRefundGas() {
            return this.refundGas;
        }

        public MessageFrame.State getState() {
            return this.state;
        }

        public Optional<ExceptionalHaltReason> getHaltReason() {
            return this.haltReason;
        }
    }
}

