/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.LazyValue;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.config.AbstractConfigSource;
import io.helidon.config.AbstractConfigSourceBuilder;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.ParsableSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class ClasspathConfigSource
extends AbstractConfigSource
implements ConfigSource,
ParsableSource {
    private final String resource;
    private final URL resourceUrl;
    private final LazyValue<Optional<MediaType>> mediaType;

    ClasspathConfigSource(Builder builder) {
        super(builder);
        this.resource = builder.resource;
        this.resourceUrl = builder.url;
        this.mediaType = LazyValue.create(() -> {
            if (this.resourceUrl == null) {
                return MediaTypes.detectType((String)this.resource);
            }
            return MediaTypes.detectType((URL)this.resourceUrl);
        });
    }

    public static ClasspathConfigSource create(Config metaConfig) throws ConfigMappingException, MissingValueException {
        return ClasspathConfigSource.builder().config(metaConfig).build();
    }

    public static ClasspathConfigSource create(String resource) {
        return ClasspathConfigSource.builder().resource(resource).build();
    }

    public static Collection<? super ClasspathConfigSource> createAll(String resource) {
        Enumeration<URL> resources = ClasspathConfigSource.findAllResources(resource);
        if (resources.hasMoreElements()) {
            LinkedList<ClasspathConfigSource> sources = new LinkedList<ClasspathConfigSource>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                sources.add(ClasspathConfigSource.builder().url(url).build());
            }
            return sources;
        }
        return List.of(ClasspathConfigSource.create(resource));
    }

    public static List<ConfigSource> createAll(Config metaConfig) {
        String resource = (String)metaConfig.get("resource").asString().get();
        Enumeration<URL> resources = ClasspathConfigSource.findAllResources(resource);
        if (resources.hasMoreElements()) {
            LinkedList<ConfigSource> sources = new LinkedList<ConfigSource>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                sources.add(ClasspathConfigSource.builder().config(metaConfig).url(url).build());
            }
            return sources;
        }
        return List.of(ClasspathConfigSource.create(metaConfig));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected String uid() {
        return null == this.resourceUrl ? this.resource : this.resourceUrl.toString();
    }

    @Override
    public Optional<ConfigParser.Content> load() throws ConfigException {
        InputStream inputStream;
        if (this.resourceUrl == null) {
            return Optional.empty();
        }
        try {
            inputStream = this.resourceUrl.openStream();
        }
        catch (IOException e) {
            throw new ConfigException("Failed to read configuration from classpath, resource: " + this.resource, e);
        }
        ConfigParser.Content.Builder builder = ConfigParser.Content.builder().data(inputStream);
        ((Optional)this.mediaType.get()).ifPresent(builder::mediaType);
        return Optional.of(builder.build());
    }

    @Override
    public Function<String, Optional<InputStream>> relativeResolver() {
        return it -> {
            int lastSlash = this.resource.lastIndexOf(47);
            Object resourceToFind = lastSlash > -1 ? this.resource.substring(0, lastSlash + 1) + it : it;
            URL resourceUrl = ClasspathConfigSource.class.getClassLoader().getResource((String)resourceToFind);
            if (resourceUrl == null) {
                return Optional.empty();
            }
            try {
                return Optional.of(resourceUrl.openStream());
            }
            catch (IOException e) {
                throw new ConfigException("Failed to read configuration from classpath, resource: " + (String)resourceToFind, e);
            }
        };
    }

    @Override
    public String toString() {
        return "classpath: " + this.resource;
    }

    @Override
    public Optional<MediaType> mediaType() {
        return super.mediaType();
    }

    @Override
    public Optional<ConfigParser> parser() {
        return super.parser();
    }

    private static Enumeration<URL> findAllResources(String resource) {
        String cleaned = resource.startsWith("/") ? resource.substring(1) : resource;
        try {
            return Thread.currentThread().getContextClassLoader().getResources(cleaned);
        }
        catch (IOException e) {
            throw new ConfigException("Could not access config resource " + resource, e);
        }
    }

    public static final class Builder
    extends AbstractConfigSourceBuilder<Builder, Void>
    implements ParsableSource.Builder<Builder>,
    io.helidon.common.Builder<Builder, ClasspathConfigSource> {
        private URL url;
        private String resource;

        private Builder() {
        }

        public ClasspathConfigSource build() {
            return new ClasspathConfigSource(this);
        }

        @Override
        public Builder config(Config metaConfig) {
            metaConfig.get("resource").asString().ifPresent(this::resource);
            return (Builder)super.config(metaConfig);
        }

        @Override
        public Builder parser(ConfigParser parser) {
            return (Builder)super.parser(parser);
        }

        @Override
        public Builder mediaType(MediaType mediaType) {
            return (Builder)super.mediaType(mediaType);
        }

        public Builder resource(String resource) {
            String cleaned = resource.startsWith("/") ? resource.substring(1) : resource;
            this.resource = resource;
            this.url = Thread.currentThread().getContextClassLoader().getResource(cleaned);
            return this;
        }

        private Builder url(URL url) {
            this.url = url;
            return this;
        }
    }
}

