/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.operations;

import com.hedera.node.app.service.contract.impl.exec.operations.CustomizedOpcodes;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.config.data.ContractsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class CustomChainIdOperation
extends AbstractOperation {
    private final long cost;

    public CustomChainIdOperation(@NonNull GasCalculator gasCalculator) {
        super(CustomizedOpcodes.CHAINID.opcode(), "CHAINID", 0, 1, gasCalculator);
        this.cost = Objects.requireNonNull(gasCalculator).getBaseTierGasCost();
    }

    public Operation.OperationResult execute(@NonNull MessageFrame frame, @NonNull EVM evm) {
        if (frame.getRemainingGas() < this.cost) {
            return new Operation.OperationResult(this.cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        int chainIdAsInt = ((ContractsConfig)FrameUtils.configOf(frame).getConfigData(ContractsConfig.class)).chainId();
        Bytes32 chainId = Bytes32.fromHexStringLenient((CharSequence)Integer.toString(chainIdAsInt, 16));
        frame.pushStackItem((Bytes)chainId);
        return new Operation.OperationResult(this.cost, null);
    }
}

