/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.service.contract.impl.exec.failure.CustomExceptionalHaltReason;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.precompile.PrecompiledContract;

public record FullResult(@NonNull PrecompiledContract.PrecompileContractResult result, long gasRequirement, @Nullable ContractCallStreamBuilder recordBuilder) {
    public FullResult {
        Objects.requireNonNull(result);
    }

    public Bytes output() {
        return this.result.getOutput();
    }

    public boolean isRefundGas() {
        return this.result.isRefundGas();
    }

    public static FullResult ordinalRevertResult(@NonNull ResponseCodeEnum reason, long gasRequirement) {
        Objects.requireNonNull(reason);
        return new FullResult(PrecompiledContract.PrecompileContractResult.revert((Bytes)Bytes.wrap((Bytes[])new Bytes[]{UInt256.valueOf((long)reason.protoOrdinal())})), gasRequirement, null);
    }

    public static FullResult revertResult(@NonNull ResponseCodeEnum reason, long gasRequirement) {
        Objects.requireNonNull(reason);
        return new FullResult(PrecompiledContract.PrecompileContractResult.revert((Bytes)Bytes.wrap((byte[])reason.protoName().getBytes())), gasRequirement, null);
    }

    public static FullResult revertResult(@NonNull Bytes reason, long gasRequirement) {
        Objects.requireNonNull(reason);
        return new FullResult(PrecompiledContract.PrecompileContractResult.revert((Bytes)reason), gasRequirement, null);
    }

    public static FullResult revertResult(@NonNull ContractCallStreamBuilder recordBuilder, long gasRequirement) {
        Objects.requireNonNull(recordBuilder);
        return new FullResult(PrecompiledContract.PrecompileContractResult.revert((Bytes)Bytes.wrap((Bytes[])new Bytes[]{UInt256.valueOf((long)recordBuilder.status().protoOrdinal())})), gasRequirement, recordBuilder);
    }

    public static FullResult haltResult(@NonNull ContractCallStreamBuilder recordBuilder, long gasRequirement) {
        Objects.requireNonNull(recordBuilder);
        CustomExceptionalHaltReason reason = recordBuilder.status() == ResponseCodeEnum.NOT_SUPPORTED ? CustomExceptionalHaltReason.NOT_SUPPORTED : CustomExceptionalHaltReason.ERROR_DECODING_PRECOMPILE_INPUT;
        return new FullResult(PrecompiledContract.PrecompileContractResult.halt((Bytes)Bytes.EMPTY, Optional.of(reason)), gasRequirement, recordBuilder);
    }

    public static FullResult haltResult(@NonNull ExceptionalHaltReason reason, long gasRequirement) {
        Objects.requireNonNull(reason);
        return new FullResult(PrecompiledContract.PrecompileContractResult.halt((Bytes)Bytes.EMPTY, Optional.of(reason)), gasRequirement, null);
    }

    public static FullResult successResult(@NonNull ByteBuffer encoded, long gasRequirement, @NonNull ContractCallStreamBuilder recordBuilder) {
        Objects.requireNonNull(encoded);
        return new FullResult(PrecompiledContract.PrecompileContractResult.success((Bytes)Bytes.wrap((byte[])encoded.array())), gasRequirement, recordBuilder);
    }

    public static FullResult successResult(@NonNull ByteBuffer encoded, long gasRequirement) {
        Objects.requireNonNull(encoded);
        return new FullResult(PrecompiledContract.PrecompileContractResult.success((Bytes)Bytes.wrap((byte[])encoded.array())), gasRequirement, null);
    }

    public static FullResult successResult(@NonNull Bytes encoded, long gasRequirement) {
        Objects.requireNonNull(encoded);
        return new FullResult(PrecompiledContract.PrecompileContractResult.success((Bytes)encoded), gasRequirement, null);
    }

    public static FullResult haltResult(long gasRequirement) {
        return new FullResult(PrecompiledContract.PrecompileContractResult.halt((Bytes)Bytes.EMPTY, Optional.of(CustomExceptionalHaltReason.ERROR_DECODING_PRECOMPILE_INPUT)), gasRequirement, null);
    }
}

