/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.contract.EvmTransactionResult;
import com.hedera.hapi.node.contract.InternalCallContext;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.node.util.UtilPrngTransactionBody;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.InvalidTransactionException;
import com.hedera.node.app.hapi.utils.ValidationUtils;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.AbstractFullContract;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HederaSystemContract;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.node.app.service.contract.impl.state.AbstractProxyEvmAccount;
import com.hedera.node.app.service.contract.impl.state.ProxyWorldUpdater;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.contract.impl.utils.SystemContractUtils;
import com.hederahashgraph.api.proto.java.ResponseCodeEnum;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.precompile.PrecompiledContract;

@Singleton
public class PrngSystemContract
extends AbstractFullContract
implements HederaSystemContract {
    private static final Logger log = LogManager.getLogger(PrngSystemContract.class);
    private static final String PRECOMPILE_NAME = "PRNG";
    static final int PSEUDORANDOM_SEED_GENERATOR_SELECTOR = -667158111;
    public static final String PRNG_PRECOMPILE_ADDRESS = "0x169";
    public static final ContractID PRNG_CONTRACT_ID = ContractID.newBuilder().contractNum(ConversionUtils.numberOfLongZero(Address.fromHexString((String)"0x169"))).build();
    private long gasRequirement;

    @Inject
    public PrngSystemContract(@NonNull GasCalculator gasCalculator) {
        super(PRECOMPILE_NAME, gasCalculator);
    }

    @Override
    public FullResult computeFully(@NonNull ContractID contractID, @NonNull Bytes input, @NonNull MessageFrame frame) {
        Objects.requireNonNull(input);
        Objects.requireNonNull(frame);
        this.gasRequirement = this.calculateGas(frame);
        try {
            ValidationUtils.validateTrue((input.size() >= 4 ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TRANSACTION_BODY);
            Bytes randomNum = this.generatePseudoRandomData(input, frame);
            Objects.requireNonNull(randomNum);
            PrecompiledContract.PrecompileContractResult result = PrecompiledContract.PrecompileContractResult.success((Bytes)randomNum);
            this.createSuccessfulRecord(frame, randomNum, contractID);
            return new FullResult(result, this.gasRequirement, null);
        }
        catch (InvalidTransactionException e) {
            this.createFailedRecord(frame, e.getResponseCode(), contractID);
            return new FullResult(PrecompiledContract.PrecompileContractResult.halt((Bytes)Bytes.EMPTY, Optional.of(ExceptionalHaltReason.INVALID_OPERATION)), this.gasRequirement, null);
        }
        catch (Exception e) {
            log.warn("Internal precompile failure", (Throwable)e);
            this.createFailedRecord(frame, ResponseCodeEnum.FAIL_INVALID, contractID);
            return new FullResult(PrecompiledContract.PrecompileContractResult.halt((Bytes)Bytes.EMPTY, Optional.of(ExceptionalHaltReason.INVALID_OPERATION)), this.gasRequirement, null);
        }
    }

    void createSuccessfulRecord(@NonNull MessageFrame frame, @NonNull Bytes randomNum, @NonNull ContractID contractID) {
        if (!frame.isStatic()) {
            Objects.requireNonNull(frame);
            Objects.requireNonNull(randomNum);
            Objects.requireNonNull(contractID);
            ProxyWorldUpdater updater = (ProxyWorldUpdater)frame.getWorldUpdater();
            AccountID senderId = ((AbstractProxyEvmAccount)updater.getAccount(frame.getSenderAddress())).hederaId();
            ContractFunctionResult data = SystemContractUtils.successResultOfZeroValueTraceable(this.gasRequirement, randomNum, frame.getRemainingGas(), frame.getInputData(), senderId);
            EvmTransactionResult txResult = SystemContractUtils.txSuccessResultOfZeroValueTraceable(this.gasRequirement, randomNum, frame.getRemainingGas(), frame.getInputData(), senderId);
            updater.enhancement().systemOperations().dispatch(this.synthBody(), key -> VerificationStrategy.Decision.INVALID, senderId, ContractCallStreamBuilder.class).contractCallResult(data).entropyBytes(ConversionUtils.tuweniToPbjBytes(randomNum)).evmCallTransactionResult(txResult);
        }
    }

    void createFailedRecord(@NonNull MessageFrame frame, @NonNull ResponseCodeEnum responseCode, @NonNull ContractID contractID) {
        if (!frame.isStatic()) {
            Objects.requireNonNull(frame);
            Objects.requireNonNull(contractID);
            ProxyWorldUpdater updater = (ProxyWorldUpdater)frame.getWorldUpdater();
            AccountID senderId = ((AbstractProxyEvmAccount)updater.getAccount(frame.getSenderAddress())).hederaId();
            com.hedera.pbj.runtime.io.buffer.Bytes callData = ConversionUtils.tuweniToPbjBytes(frame.getInputData());
            ContractFunctionResult contractResult = ContractFunctionResult.newBuilder().gasUsed(this.gasRequirement).functionParameters(callData).errorMessage("").contractID(contractID).senderId(senderId).gas(frame.getRemainingGas()).build();
            EvmTransactionResult txResult = EvmTransactionResult.newBuilder().internalCallContext(InternalCallContext.newBuilder().callData(callData).gas(frame.getRemainingGas())).gasUsed(this.gasRequirement).errorMessage("").contractId(contractID).senderId(senderId).build();
            updater.enhancement().systemOperations().externalizePreemptedDispatch(this.synthBody(), CommonPbjConverters.toPbj((ResponseCodeEnum)responseCode), HederaFunctionality.UTIL_PRNG).contractCallResult(contractResult).evmCallTransactionResult(txResult);
        }
    }

    private TransactionBody synthBody() {
        return TransactionBody.newBuilder().utilPrng(UtilPrngTransactionBody.DEFAULT).build();
    }

    Bytes generatePseudoRandomData(@NonNull Bytes input, @NonNull MessageFrame frame) {
        int selector = input.getInt(0);
        if (selector == -667158111) {
            return this.random256BitGenerator(frame);
        }
        throw new InvalidTransactionException("Invalid selector for PRNG precompile", ResponseCodeEnum.REVERTED_SUCCESS);
    }

    Bytes random256BitGenerator(MessageFrame frame) {
        Bytes entropy = ((ProxyWorldUpdater)frame.getWorldUpdater()).entropy();
        return entropy.slice(0, 32);
    }

    long calculateGas(@NonNull MessageFrame frame) {
        SystemContractGasCalculator gasCalculator = FrameUtils.systemContractGasCalculatorOf(frame);
        if (frame.isStatic()) {
            return gasCalculator.viewGasRequirement();
        }
        return Math.max(gasCalculator.canonicalGasRequirement(DispatchType.UTIL_PRNG), gasCalculator.viewGasRequirement());
    }
}

