/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.fungibletokeninfo.address_0x167;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HtsSystemContract;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.fungibletokeninfo.FungibleTokenInfoCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FungibleTokenInfoTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod FUNGIBLE_TOKEN_INFO = SystemContractMethod.declare("getFungibleTokenInfo(address)", "(int32,(((string,string,address,string,bool,int64,bool,(uint256,(bool,address,bytes,bytes,address))[],(uint32,address,uint32)),int64,bool,bool,bool,(uint32,address,bool,bool,address)[],(uint32,uint32,uint32,uint32,bool,address)[],(uint32,uint32,uint32,address,bool,address)[],string),int32))").withVariants(SystemContractMethod.Variant.V1, SystemContractMethod.Variant.FT).withSupportedAddress(HtsSystemContract.HTS_167_CONTRACT_ID).withCategory(SystemContractMethod.Category.TOKEN_QUERY);

    @Inject
    public FungibleTokenInfoTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(FUNGIBLE_TOKEN_INFO);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isMethod(FUNGIBLE_TOKEN_INFO);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        Tuple args = FUNGIBLE_TOKEN_INFO.decodeCall(attempt.input().toArrayUnsafe());
        Token token = attempt.linkedToken(ConversionUtils.fromHeadlongAddress((Address)args.get(0)));
        return new FungibleTokenInfoCall(attempt.systemContractGasCalculator(), attempt.enhancement(), attempt.isStaticCall(), token, attempt.configuration(), FUNGIBLE_TOKEN_INFO.function());
    }
}

