/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotated;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.ElementSignature;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.common.types.TypedElementInfoSupport;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@Prototype.Blueprint(decorator=TypedElementInfoSupport.BuilderDecorator.class)
@Prototype.CustomMethods(value=TypedElementInfoSupport.class)
interface TypedElementInfoBlueprint
extends Annotated {
    @Option.Redundant
    public Optional<String> description();

    @Option.Required
    public TypeName typeName();

    @Option.Required
    public String elementName();

    @Deprecated(forRemoval=true, since="4.1.0")
    @Option.Required
    @Option.Deprecated(value="kind")
    @Option.Redundant
    public String elementTypeKind();

    public ElementKind kind();

    @Option.Redundant
    public Optional<String> defaultValue();

    @Option.Redundant
    public List<Annotation> elementTypeAnnotations();

    @Option.Redundant
    public List<TypeName> componentTypes();

    @Deprecated(forRemoval=true, since="4.1.0")
    @Option.Singular
    @Option.Redundant
    @Option.Deprecated(value="elementModifiers")
    public Set<String> modifiers();

    @Option.Redundant
    @Option.Singular
    public Set<Modifier> elementModifiers();

    @Option.Redundant
    public AccessModifier accessModifier();

    public Optional<TypeName> enclosingType();

    @Option.Singular
    public List<TypedElementInfo> parameterArguments();

    public Set<TypeName> throwsChecked();

    @Option.Redundant
    public Optional<Object> originatingElement();

    default public Object originatingElementValue() {
        return this.originatingElement().orElseGet(this::signature);
    }

    @Option.Access(value="")
    public ElementSignature signature();

    @Option.Singular
    public List<TypeName> typeParameters();
}

