/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.state.listeners;

import com.hedera.node.app.blocks.BlockStreamManager;
import com.swirlds.platform.system.state.notifications.AsyncFatalIssListener;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.notification.IssNotification;

@Singleton
public class FatalIssListenerImpl
implements AsyncFatalIssListener {
    private static final Logger log = LogManager.getLogger(FatalIssListenerImpl.class);
    private final BlockStreamManager blockStreamManager;

    @Inject
    public FatalIssListenerImpl(@NonNull BlockStreamManager blockStreamManager) {
        this.blockStreamManager = Objects.requireNonNull(blockStreamManager);
    }

    public void notify(@NonNull IssNotification data) {
        log.warn("ISS detected (type={}, round={})", (Object)data.getIssType(), (Object)data.getRound());
        this.blockStreamManager.notifyFatalEvent();
    }
}

