/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.util;

import com.hedera.hapi.node.base.schema.QueryHeaderSchema;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.schema.TransactionGetReceiptQuerySchema;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProtobufUtils {
    private static final Set<Integer> QUERY_FIELDS = Stream.of(Query.QueryOneOfType.values()).map(Query.QueryOneOfType::protoOrdinal).collect(Collectors.toUnmodifiableSet());

    private ProtobufUtils() {
    }

    @NonNull
    public static Bytes extractPaymentBytes(@NonNull Bytes serializedQuery) throws IOException, ParseException {
        Bytes queryBody = ProtobufUtils.extractQuery(serializedQuery.toReadableSequentialData());
        Bytes queryHeader = ProtobufUtils.extractFieldBytes(queryBody.toReadableSequentialData(), TransactionGetReceiptQuerySchema.HEADER);
        return ProtobufUtils.extractFieldBytes(queryHeader.toReadableSequentialData(), QueryHeaderSchema.PAYMENT);
    }

    @NonNull
    private static Bytes extractFieldBytes(@NonNull ReadableSequentialData input, @NonNull FieldDefinition field) throws IOException, ParseException {
        if (field.repeated()) {
            throw new IllegalArgumentException("Cannot extract field bytes for a repeated field: " + String.valueOf(field));
        }
        if (ProtoWriterTools.wireType((FieldDefinition)field) != ProtoConstants.WIRE_TYPE_DELIMITED) {
            throw new IllegalArgumentException("Cannot extract field bytes for a non-length-delimited field: " + String.valueOf(field));
        }
        while (input.hasRemaining()) {
            int tag;
            try {
                tag = input.readVarInt(false);
            }
            catch (BufferUnderflowException e) {
                break;
            }
            int fieldNum = tag >> 3;
            ProtoConstants wireType = ProtoConstants.get((int)(tag & 7));
            if (fieldNum == field.number()) {
                if (wireType != ProtoConstants.WIRE_TYPE_DELIMITED) {
                    throw new ParseException("Unexpected wire type: " + tag);
                }
                int length = input.readVarInt(false);
                return input.readBytes(length);
            }
            ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)wireType);
        }
        throw new ParseException("Field not found: " + String.valueOf(field));
    }

    @NonNull
    private static Bytes extractQuery(@NonNull ReadableSequentialData input) throws IOException, ParseException {
        while (input.hasRemaining()) {
            int tag;
            try {
                tag = input.readVarInt(false);
            }
            catch (BufferUnderflowException e) {
                break;
            }
            int fieldNum = tag >> 3;
            ProtoConstants wireType = ProtoConstants.get((int)(tag & 7));
            if (QUERY_FIELDS.contains(fieldNum)) {
                if (wireType != ProtoConstants.WIRE_TYPE_DELIMITED) {
                    throw new ParseException("Unexpected wire type: " + tag);
                }
                int length = input.readVarInt(false);
                return input.readBytes(length);
            }
            ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)wireType);
        }
        throw new ParseException("Query not found");
    }
}

