/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.validation;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.spi.validation.AttributeValidator;
import com.hedera.node.app.spi.validation.ExpiryMeta;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.EntitiesConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.LedgerConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class AttributeValidatorImpl
implements AttributeValidator {
    private final HandleContext context;

    public AttributeValidatorImpl(@NonNull HandleContext context) {
        this.context = Objects.requireNonNull(context, "context must not be null");
    }

    public void validateKey(@NonNull Key key) {
        this.validateKeyAtLevel(key, 1);
        if (!KeyUtils.isValid((Key)key)) {
            throw new HandleException(ResponseCodeEnum.BAD_ENCODING);
        }
    }

    public void validateKey(@NonNull Key key, @NonNull ResponseCodeEnum responseCodeEnum) {
        try {
            this.validateKey(key);
        }
        catch (HandleException e) {
            throw new HandleException(responseCodeEnum);
        }
    }

    public void validateMemo(@Nullable String memo) {
        int maxMemoUtf8Bytes;
        if (memo == null) {
            return;
        }
        byte[] raw = memo.getBytes(StandardCharsets.UTF_8);
        if (raw.length > (maxMemoUtf8Bytes = ((HederaConfig)this.context.configuration().getConfigData(HederaConfig.class)).transactionMaxMemoUtf8Bytes())) {
            throw new HandleException(ResponseCodeEnum.MEMO_TOO_LONG);
        }
        if (AttributeValidatorImpl.containsZeroByte(raw)) {
            throw new HandleException(ResponseCodeEnum.INVALID_ZERO_BYTE_IN_STRING);
        }
    }

    public void validateExpiry(long expiry) {
        long maxEntityLifetime = ((EntitiesConfig)this.context.configuration().getConfigData(EntitiesConfig.class)).maxLifetime();
        long now = this.context.consensusNow().getEpochSecond();
        long expiryGivenMaxLifetime = now + maxEntityLifetime;
        long impliedExpiry = expiry == ExpiryMeta.NA ? expiryGivenMaxLifetime : expiry;
        HandleException.validateTrue((impliedExpiry > now && impliedExpiry <= expiryGivenMaxLifetime ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_EXPIRATION_TIME);
    }

    public void validateAutoRenewPeriod(long autoRenewPeriod) {
        LedgerConfig ledgerConfig = (LedgerConfig)this.context.configuration().getConfigData(LedgerConfig.class);
        HandleException.validateTrue((autoRenewPeriod > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_RENEWAL_PERIOD);
        HandleException.validateTrue((autoRenewPeriod >= ledgerConfig.autoRenewPeriodMinDuration() && autoRenewPeriod <= ledgerConfig.autoRenewPeriodMaxDuration() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.AUTORENEW_DURATION_NOT_IN_RANGE);
    }

    private void validateKeyAtLevel(@NonNull Key key, int level) {
        if (level > 15) {
            throw new HandleException(ResponseCodeEnum.BAD_ENCODING);
        }
        if (!key.hasThresholdKey() && !key.hasKeyList()) {
            this.validateSimple(key);
        } else if (key.hasThresholdKey() && key.thresholdKeyOrThrow().hasKeys()) {
            key.thresholdKeyOrThrow().keysOrThrow().keys().forEach(k -> this.validateKeyAtLevel((Key)k, level + 1));
        } else {
            key.keyListOrThrow().keys().forEach(k -> this.validateKeyAtLevel((Key)k, level + 1));
        }
    }

    private void validateSimple(@NonNull Key key) {
        if (key.key().kind() == Key.KeyOneOfType.UNSET) {
            throw new HandleException(ResponseCodeEnum.BAD_ENCODING);
        }
    }

    private static boolean containsZeroByte(@NonNull byte[] bytes) {
        for (byte b : bytes) {
            if (b != 0) continue;
            return true;
        }
        return false;
    }
}

