/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.hapi.fees;

import java.util.LinkedHashMap;
import java.util.Map;

public class FeeResult {
    public long service = 0L;
    public long node = 0L;
    public long network = 0L;
    public Map<String, FeeDetail> details = new LinkedHashMap<String, FeeDetail>();

    public void addServiceFee(String label, long count, long cost) {
        this.details.put(label, new FeeDetail(count, cost));
        this.service = FeeResult.clampedAdd(this.service, cost);
    }

    public void addNodeFee(String label, long count, long cost) {
        this.details.put(label, new FeeDetail(count, cost));
        this.node = FeeResult.clampedAdd(this.node, cost);
    }

    public void addNetworkFee(String label, long count, long cost) {
        this.details.put(label, new FeeDetail(count, cost));
        this.network = FeeResult.clampedAdd(this.network, cost);
    }

    public long total() {
        return FeeResult.clampedAdd(FeeResult.clampedAdd(this.node, this.network), this.service);
    }

    public String toString() {
        return "FeeResult{fee=" + this.total() + ", details=" + String.valueOf(this.details) + "}";
    }

    private static long clampedAdd(long a, long b) {
        try {
            return Math.addExact(a, b);
        }
        catch (ArithmeticException ae) {
            return a > 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
    }

    public static class FeeDetail {
        public long count;
        public long fee;

        public FeeDetail(long count, long fee) {
            this.count = count;
            this.fee = fee;
        }

        public String toString() {
            return "FeeDetail{" + this.count + ", " + this.fee + "}";
        }
    }
}

