/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.hapi.fees.apis.common;

import com.hedera.hapi.node.base.HederaFunctionality;
import java.security.InvalidParameterException;
import java.util.Map;
import org.hiero.hapi.fees.FeeModel;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.ExtraFeeReference;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.NodeFee;

public abstract class AbstractBaseFeeModel
implements FeeModel {
    private final HederaFunctionality api;
    private final String description;

    public AbstractBaseFeeModel(HederaFunctionality api, String description) {
        this.api = api;
        this.description = description;
    }

    @Override
    public HederaFunctionality getApi() {
        return this.api;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected FeeResult computeNodeAndNetworkFees(Map<Extra, Long> params, FeeSchedule feeSchedule) {
        FeeResult result = new FeeResult();
        NodeFee nodeFee = feeSchedule.node();
        result.addNodeFee("Node base fee", 1L, nodeFee.baseFee());
        for (ExtraFeeReference ref : nodeFee.extras()) {
            if (!params.containsKey(ref.name())) {
                throw new InvalidParameterException("input params missing " + String.valueOf(ref.name()) + " required by node fee ");
            }
            int included = ref.includedCount();
            long used = params.get(ref.name());
            long extraFee = FeeScheduleUtils.lookupExtraFee(feeSchedule, ref).fee();
            if (used <= (long)included) continue;
            long overage = used - (long)included;
            result.addNodeFee("Node Overage of " + ref.name().name(), overage, overage * extraFee);
        }
        int multiplier = feeSchedule.network().multiplier();
        result.addNetworkFee("Total Network fee", multiplier, result.node * (long)multiplier);
        return result;
    }
}

