/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIJSON;
import com.esaulpaugh.headlong.abi.ABIObject;
import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.TypeEnum;
import com.esaulpaugh.headlong.util.FastHex;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Strings;
import com.joemelsha.crypto.hash.Keccak;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntFunction;

public final class Function
implements ABIObject {
    public static final int SELECTOR_LEN = 4;
    private static final int MAX_NAME_CHARS = 384;
    private final TypeEnum type;
    private final String name;
    private final TupleType<Tuple> inputTypes;
    private final TupleType<Tuple> outputTypes;
    private final String stateMutability;
    private final String hashAlgorithm;
    private final byte[] selector = new byte[4];

    public Function(String signature) {
        this(signature, signature.indexOf(40), TupleType.EMPTY, 0);
    }

    public Function(String signature, String outputs) {
        this(0, signature, outputs);
    }

    private Function(int flags, String signature, String outputs) {
        this(signature, signature.indexOf(40), outputs != null ? TupleType.parse(flags, outputs) : TupleType.empty(flags), flags);
    }

    private Function(String signature, int nameLength, TupleType<?> outputs, int flags) {
        this(TypeEnum.FUNCTION, signature.substring(0, nameLength), TupleType.parse(flags, signature.substring(nameLength)), outputs, null, Function.newDefaultDigest());
    }

    public Function(TypeEnum type, String name, TupleType<?> inputs, TupleType<?> outputs, String stateMutability, MessageDigest messageDigest) {
        this.type = Objects.requireNonNull(type);
        this.name = name != null ? Function.validateName(name) : null;
        this.inputTypes = Objects.requireNonNull(inputs);
        this.outputTypes = Objects.requireNonNull(outputs);
        this.stateMutability = stateMutability;
        this.hashAlgorithm = Objects.requireNonNull(messageDigest.getAlgorithm());
        this.validateFunction();
        this.generateSelector(messageDigest);
    }

    @Override
    public TypeEnum getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <T extends Tuple> TupleType<T> getInputs() {
        return this.inputTypes;
    }

    public <T extends Tuple> TupleType<T> getOutputs() {
        return this.outputTypes;
    }

    public String getStateMutability() {
        return this.stateMutability;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public byte[] selector() {
        return Arrays.copyOf(this.selector, this.selector.length);
    }

    public String selectorHex() {
        return Strings.encode(this.selector);
    }

    @Override
    public String getCanonicalSignature() {
        return this.name != null ? this.name + this.inputTypes.canonicalType : this.inputTypes.canonicalType;
    }

    private void validateFunction() {
        switch (this.type.ordinal()) {
            case 0: {
                if (this.name == null) {
                    throw this.validationErr("define name");
                }
                return;
            }
            case 1: {
                if (!"payable".equals(this.stateMutability)) {
                    throw this.validationErr("define stateMutability as \"payable\"");
                }
            }
            case 2: {
                if (!this.inputTypes.isEmpty()) {
                    throw this.validationErr("define no inputs");
                }
            }
            case 3: {
                if (!this.outputTypes.isEmpty()) {
                    throw this.validationErr("define no outputs");
                }
                if (this.name != null) {
                    throw this.validationErr("not define name");
                }
                return;
            }
        }
        throw TypeEnum.unexpectedType(this.type.toString());
    }

    private IllegalArgumentException validationErr(String typeRuleStr) {
        return new IllegalArgumentException("type is \"" + (Object)((Object)this.type) + "\"; functions of this type must " + typeRuleStr);
    }

    private void generateSelector(MessageDigest messageDigest) {
        messageDigest.reset();
        messageDigest.update(Strings.decode(this.getCanonicalSignature(), 3));
        try {
            messageDigest.digest(this.selector, 0, 4);
        }
        catch (DigestException de) {
            throw new AssertionError((Object)de);
        }
    }

    private int validatedCallLength(Tuple args) {
        return 4 + this.inputTypes.validate(args);
    }

    public int measureCallLength(Tuple args) {
        return this.validatedCallLength(args);
    }

    public ByteBuffer encodeCallWithArgs(Object ... args) {
        return this.encodeCall(new Tuple(args));
    }

    public ByteBuffer encodeCall(Tuple args) {
        ByteBuffer dest = ByteBuffer.allocate(this.validatedCallLength(args));
        dest.put(this.selector);
        this.inputTypes.encodeTail(args, dest);
        dest.flip();
        return dest;
    }

    public void encodeCall(Tuple args, ByteBuffer dest) {
        this.inputTypes.validate(args);
        dest.put(this.selector);
        this.inputTypes.encodeTail(args, dest);
    }

    public <T extends Tuple> T decodeCall(byte[] call) {
        this.checkSelector(Arrays.copyOf(call, 4));
        return (T)((Tuple)this.inputTypes.decode(call, 4, call.length - 4));
    }

    public <T extends Tuple> T decodeCall(ByteBuffer buffer) {
        this.checkSelector(buffer);
        return (T)((Tuple)this.inputTypes.decode(buffer));
    }

    public <T> T decodeCall(byte[] call, int ... indices) {
        return this.decodeCall(ByteBuffer.wrap(call), indices);
    }

    public <T> T decodeCall(ByteBuffer buffer, int ... indices) {
        this.checkSelector(buffer);
        return this.inputTypes.decode(buffer, indices);
    }

    private void checkSelector(ByteBuffer bb) {
        byte[] four = new byte[4];
        bb.get(four, 0, four.length);
        this.checkSelector(four);
    }

    private void checkSelector(byte[] found) {
        if (!MessageDigest.isEqual(found, this.selector)) {
            throw new IllegalArgumentException("given selector does not match: expected: " + this.selectorHex() + ", found: " + Strings.encode(found));
        }
    }

    public <T extends Tuple> T decodeReturn(byte[] returnVals) {
        return (T)((Tuple)this.outputTypes.decode(returnVals));
    }

    public <T extends Tuple> T decodeReturn(ByteBuffer buf) {
        return (T)((Tuple)this.outputTypes.decode(buf));
    }

    public <T> T decodeReturn(byte[] returnVals, int ... indices) {
        return this.decodeReturn(ByteBuffer.wrap(returnVals), indices);
    }

    public <T> T decodeReturn(ByteBuffer buf, int ... indices) {
        return this.outputTypes.decode(buf, indices);
    }

    public <J> J decodeSingletonReturn(byte[] singleton) {
        if (this.outputTypes.size() == 1) {
            return ((ABIType)this.outputTypes.get(0)).decode(singleton);
        }
        throw new IllegalArgumentException("return type not a singleton: " + this.outputTypes.canonicalType);
    }

    public <J> J decodeSingletonReturn(ByteBuffer buf) {
        if (this.outputTypes.size() == 1) {
            return ((ABIType)this.outputTypes.get(0)).decode(buf);
        }
        throw new IllegalArgumentException("return type not a singleton: " + this.outputTypes.canonicalType);
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    public int hashCode() {
        return 31 * Objects.hash(new Object[]{this.type, this.name, this.inputTypes, this.outputTypes, this.stateMutability, this.hashAlgorithm}) + Arrays.hashCode(this.selector);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Function)) {
            return false;
        }
        Function other = (Function)o;
        return other.type == this.type && Objects.equals(other.name, this.name) && other.inputTypes.equals(this.inputTypes) && other.outputTypes.equals(this.outputTypes) && Objects.equals(other.stateMutability, this.stateMutability) && other.hashAlgorithm.equals(this.hashAlgorithm) && MessageDigest.isEqual(other.selector, this.selector);
    }

    public String toString() {
        return this.toJson(true);
    }

    private static String validateName(String input) {
        int len = input.length();
        if (len > 384) {
            throw new IllegalArgumentException("function name is too long: " + len + " > " + 384);
        }
        for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            if (c < '\u0080' && c != '(') continue;
            throw new IllegalArgumentException("illegal name char");
        }
        return input;
    }

    public String annotateCall(byte[] call) {
        return this.annotateCall((Tuple)this.decodeCall(call));
    }

    public String annotateCall(Tuple args) {
        return this.inputTypes.annotate(args, new StringBuilder(768).append(this.getCanonicalSignature()).append(":\n").append("ID       ").append(this.selectorHex()));
    }

    public static Function parse(String signature) {
        return new Function(signature);
    }

    public static Function parse(String signature, String outputs) {
        return new Function(signature, outputs);
    }

    public static Function parse(int flags, String signature, String outputs) {
        return new Function(flags, signature, outputs);
    }

    public static MessageDigest newDefaultDigest() {
        return new Keccak(256);
    }

    public static String formatCall(byte[] call) {
        return Function.formatCall(call, row -> ABIType.padLabel(0, Integer.toString(row)));
    }

    public static String formatCall(byte[] buffer, IntFunction<String> labeler) {
        int bodyLen = buffer.length - 4;
        Integers.checkIsMultiple(bodyLen, 32);
        return ABIType.finishFormat(buffer, 4, buffer.length, labeler, new StringBuilder(ABIType.PADDED_LABEL_LEN + 8 + bodyLen / 32 * ABIType.CHARS_PER_LINE).append("ID       ").append(FastHex.encodeToString(buffer, 0, 4)));
    }

    public static Function fromJson(String objectJson) {
        return Function.fromJson(0, objectJson);
    }

    public static Function fromJson(int flags, String objectJson) {
        return Function.fromJson(flags, objectJson, Function.newDefaultDigest());
    }

    public static Function fromJson(int flags, String objectJson, MessageDigest digest) {
        return (Function)ABIJSON.parseABIObject(objectJson, ABIJSON.FUNCTIONS, digest, flags);
    }

    public static Function fromJson(int flags, InputStream jsonStream, MessageDigest digest) {
        return (Function)ABIJSON.parseABIObject(jsonStream, ABIJSON.FUNCTIONS, digest, flags);
    }
}

