/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gossip.shadowgraph;

import com.hedera.hapi.platform.event.GossipEvent;
import com.swirlds.base.time.Time;
import com.swirlds.common.utility.throttle.RateLimiter;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.gossip.IntakeEventCounter;
import com.swirlds.platform.gossip.permits.SyncGuard;
import com.swirlds.platform.gossip.rpc.GossipRpcReceiver;
import com.swirlds.platform.gossip.rpc.GossipRpcSender;
import com.swirlds.platform.gossip.rpc.SyncData;
import com.swirlds.platform.gossip.shadowgraph.ReservedEventWindow;
import com.swirlds.platform.gossip.shadowgraph.RpcPeerState;
import com.swirlds.platform.gossip.shadowgraph.RpcShadowgraphSynchronizer;
import com.swirlds.platform.gossip.shadowgraph.ShadowEvent;
import com.swirlds.platform.gossip.shadowgraph.SyncPhase;
import com.swirlds.platform.gossip.shadowgraph.SyncResult;
import com.swirlds.platform.gossip.shadowgraph.SyncUtils;
import com.swirlds.platform.metrics.SyncMetrics;
import com.swirlds.platform.reconnect.FallenBehindMonitor;
import com.swirlds.platform.reconnect.FallenBehindStatus;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.CompareTo;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;

public class RpcPeerHandler
implements GossipRpcReceiver {
    private static final Logger logger = LogManager.getLogger(RpcPeerHandler.class);
    private final RpcShadowgraphSynchronizer sharedShadowgraphSynchronizer;
    private final SyncMetrics syncMetrics;
    private final Time time;
    private final IntakeEventCounter intakeEventCounter;
    private final NodeId selfId;
    private final GossipRpcSender sender;
    private final NodeId peerId;
    private final Duration sleepAfterSync;
    private final Consumer<PlatformEvent> eventHandler;
    private final RpcPeerState state = new RpcPeerState();
    private final RateLimiter fallBehindRateLimiter;
    private int outgoingEventsCounter = 0;
    private int incomingEventsCounter = 0;
    private final SyncGuard syncGuard;
    private final FallenBehindMonitor fallenBehindMonitor;

    public RpcPeerHandler(@NonNull RpcShadowgraphSynchronizer sharedShadowgraphSynchronizer, @NonNull GossipRpcSender sender, @NonNull NodeId selfId, @NonNull NodeId peerId, @NonNull Duration sleepAfterSync, @NonNull SyncMetrics syncMetrics, @NonNull Time time, @NonNull IntakeEventCounter intakeEventCounter, @NonNull Consumer<PlatformEvent> eventHandler, @NonNull SyncGuard syncGuard, @NonNull FallenBehindMonitor fallenBehindMonitor) {
        this.sharedShadowgraphSynchronizer = Objects.requireNonNull(sharedShadowgraphSynchronizer);
        this.sender = Objects.requireNonNull(sender);
        this.selfId = Objects.requireNonNull(selfId);
        this.peerId = Objects.requireNonNull(peerId);
        this.sleepAfterSync = Objects.requireNonNull(sleepAfterSync);
        this.syncMetrics = Objects.requireNonNull(syncMetrics);
        this.time = Objects.requireNonNull(time);
        this.intakeEventCounter = Objects.requireNonNull(intakeEventCounter);
        this.eventHandler = Objects.requireNonNull(eventHandler);
        this.syncGuard = syncGuard;
        this.fallenBehindMonitor = fallenBehindMonitor;
        this.fallBehindRateLimiter = new RateLimiter(time, Duration.ofMinutes(1L));
    }

    public boolean checkForPeriodicActions(boolean wantToExit, boolean ignoreIncomingEvents) {
        if (!this.isSyncCooldownComplete()) {
            this.syncMetrics.doNotSyncCooldown();
            return !wantToExit;
        }
        if (this.state.peerIsBehind) {
            this.syncMetrics.doNotSyncPeerFallenBehind();
            return !wantToExit;
        }
        if (this.state.peerStillSendingEvents) {
            this.syncMetrics.doNotSyncPeerProcessingEvents();
            return true;
        }
        if (this.intakeEventCounter.hasUnprocessedEvents(this.peerId)) {
            this.syncMetrics.doNotSyncIntakeCounter();
            return !wantToExit;
        }
        if (this.state.mySyncData == null) {
            if (!wantToExit) {
                if (this.state.remoteSyncData == null) {
                    if (!this.syncGuard.isSyncAllowed(this.peerId)) {
                        this.syncMetrics.doNotSyncFairSelector();
                        return true;
                    }
                } else {
                    this.syncGuard.onForcedSync(this.peerId);
                }
                this.sendSyncData(ignoreIncomingEvents);
            }
            return !wantToExit;
        }
        this.syncMetrics.doNotSyncAlreadyStarted();
        return true;
    }

    public void cleanup() {
        this.clearInternalState();
        this.state.peerStillSendingEvents = false;
        this.sharedShadowgraphSynchronizer.deregisterPeerHandler(this);
        this.syncMetrics.reportSyncPhase(this.peerId, SyncPhase.OUTSIDE_OF_RPC);
    }

    @Override
    public void receiveSyncData(@NonNull SyncData syncMessage) {
        this.syncMetrics.reportSyncPhase(this.peerId, SyncPhase.EXCHANGING_WINDOWS);
        this.syncMetrics.acceptedSyncRequest();
        this.state.syncInitiated(syncMessage);
        this.maybeBothSentSyncData();
    }

    @Override
    public void receiveTips(@NonNull List<Boolean> remoteTipKnowledge) {
        if (this.state.remoteSyncData == null) {
            throw new IllegalStateException("Need sync data before receiving tips from " + String.valueOf(this.peerId));
        }
        List<ShadowEvent> knownTips = SyncUtils.getMyTipsTheyKnow(this.peerId, this.state.myTips, remoteTipKnowledge);
        this.state.eventsTheyHave.addAll(knownTips);
        this.syncMetrics.reportSyncPhase(this.peerId, SyncPhase.EXCHANGING_EVENTS);
        if (!this.state.remoteSyncData.dontReceiveEvents()) {
            List<PlatformEvent> sendList = this.sharedShadowgraphSynchronizer.createSendList(this.selfId, this.state.eventsTheyHave, this.state.mySyncData.eventWindow(), this.state.remoteSyncData.eventWindow());
            this.sender.sendEvents(sendList.stream().map(PlatformEvent::getGossipEvent).collect(Collectors.toList()));
            this.outgoingEventsCounter += sendList.size();
        }
        this.sender.sendEndOfEvents();
        this.finishedSendingEvents();
    }

    @Override
    public void receiveEvents(@NonNull List<GossipEvent> gossipEvents) {
        SyncData mySyncData = this.state.mySyncData;
        if (mySyncData != null && mySyncData.dontReceiveEvents()) {
            logger.warn(LogMarker.SYNC_INFO.getMarker(), "We have asked for no events, but still received an event from {}", (Object)this.peerId);
            return;
        }
        long start = this.time.nanoTime();
        this.incomingEventsCounter += gossipEvents.size();
        gossipEvents.forEach(this::handleIncomingSyncEvent);
        this.syncMetrics.eventsReceived(start, gossipEvents.size());
    }

    @Override
    public void receiveEventsFinished() {
        if (this.state.mySyncData == null) {
            this.reportSyncFinished();
        } else {
            this.syncMetrics.reportSyncPhase(this.peerId, SyncPhase.SENDING_EVENTS);
        }
        this.state.peerStillSendingEvents = false;
    }

    private void maybeBothSentSyncData() {
        if (this.state.mySyncData == null || this.state.remoteSyncData == null) {
            return;
        }
        EventWindow remoteEventWindow = this.state.remoteSyncData.eventWindow();
        this.syncMetrics.eventWindow(this.state.mySyncData.eventWindow(), remoteEventWindow);
        this.sharedShadowgraphSynchronizer.reportRoundDifference(this.state.mySyncData.eventWindow(), remoteEventWindow, this.peerId);
        FallenBehindStatus behindStatus = this.fallenBehindMonitor.check(this.state.mySyncData.eventWindow(), this.state.remoteSyncData.eventWindow(), this.peerId);
        if (behindStatus != FallenBehindStatus.NONE_FALLEN_BEHIND) {
            if (this.fallBehindRateLimiter.requestAndTrigger()) {
                logger.info(LogMarker.RECONNECT.getMarker(), "{} local ev={} remote ev={}", (Object)behindStatus, (Object)this.state.mySyncData.eventWindow(), (Object)this.state.remoteSyncData.eventWindow());
            }
            this.clearInternalState();
            if (behindStatus == FallenBehindStatus.OTHER_FALLEN_BEHIND) {
                this.syncMetrics.reportSyncPhase(this.peerId, SyncPhase.OTHER_FALLEN_BEHIND);
                this.state.peerIsBehind = true;
            } else {
                if (this.tryFixSelfFallBehind(remoteEventWindow)) {
                    this.syncMetrics.reportSyncPhase(this.peerId, SyncPhase.IDLE);
                    return;
                }
                this.syncMetrics.reportSyncPhase(this.peerId, SyncPhase.SELF_FALLEN_BEHIND);
                this.sender.breakConversation();
            }
            return;
        }
        this.syncMetrics.reportSyncPhase(this.peerId, SyncPhase.EXCHANGING_TIPS);
        this.sendKnownTips();
    }

    private boolean tryFixSelfFallBehind(EventWindow remoteEventWindow) {
        try (ReservedEventWindow latestShadowWindow = this.sharedShadowgraphSynchronizer.reserveEventWindow();){
            FallenBehindStatus behindStatus = this.fallenBehindMonitor.check(latestShadowWindow.getEventWindow(), remoteEventWindow, this.peerId);
            if (behindStatus != FallenBehindStatus.SELF_FALLEN_BEHIND) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private void sendSyncData(boolean ignoreIncomingEvents) {
        this.syncMetrics.syncStarted();
        this.syncMetrics.reportSyncPhase(this.peerId, SyncPhase.EXCHANGING_WINDOWS);
        this.state.shadowWindow = this.sharedShadowgraphSynchronizer.reserveEventWindow();
        this.state.myTips = this.sharedShadowgraphSynchronizer.getTips();
        List<Hash> tipHashes = this.state.myTips.stream().map(ShadowEvent::getEventBaseHash).collect(Collectors.toList());
        this.state.mySyncData = new SyncData(this.state.shadowWindow.getEventWindow(), tipHashes, ignoreIncomingEvents);
        this.sender.sendSyncData(this.state.mySyncData);
        this.syncMetrics.outgoingSyncRequestSent();
        this.maybeBothSentSyncData();
    }

    private void sendKnownTips() {
        List<ShadowEvent> theirTips = this.sharedShadowgraphSynchronizer.shadows(this.state.remoteSyncData.tipHashes());
        List<Boolean> theirTipsIHave = SyncUtils.getTheirTipsIHave(theirTips);
        theirTips.stream().filter(Objects::nonNull).forEach(this.state.eventsTheyHave::add);
        this.state.peerStillSendingEvents = true;
        this.sender.sendTips(theirTipsIHave);
    }

    private void finishedSendingEvents() {
        if (!this.state.peerStillSendingEvents) {
            this.reportSyncFinished();
        } else {
            this.syncMetrics.reportSyncPhase(this.peerId, SyncPhase.RECEIVING_EVENTS);
        }
        this.clearInternalState();
    }

    private void reportSyncFinished() {
        this.syncMetrics.syncDone(new SyncResult(this.peerId, this.incomingEventsCounter, this.outgoingEventsCounter), null);
        this.incomingEventsCounter = 0;
        this.outgoingEventsCounter = 0;
        this.syncMetrics.reportSyncPhase(this.peerId, SyncPhase.IDLE);
        this.syncMetrics.syncFinished();
    }

    private void clearInternalState() {
        if (this.state.mySyncData != null) {
            this.syncGuard.onSyncCompleted(this.peerId);
        }
        this.state.clear(this.time.now());
    }

    private boolean isSyncCooldownComplete() {
        Duration elapsed = Duration.between(this.state.lastSyncFinishedTime, this.time.now());
        return CompareTo.isGreaterThanOrEqualTo((Comparable)elapsed, (Object)this.sleepAfterSync);
    }

    private void handleIncomingSyncEvent(@NonNull GossipEvent gossipEvent) {
        PlatformEvent platformEvent = new PlatformEvent(gossipEvent);
        platformEvent.setSenderId(this.peerId);
        this.intakeEventCounter.eventEnteredIntakePipeline(this.peerId);
        this.eventHandler.accept(platformEvent);
    }
}

