/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.security.impl;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.identityconnectors.common.security.Encryptor;

public class EncryptorImpl
implements Encryptor {
    private static final String ALGORITHM = "AES";
    private static final String FULL_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final byte[] _defaultKeyBytes = new byte[]{35, 101, -121, 34, 89, 120, 84, 67, 100, 5, 106, -67, 52, -94, 52, 87};
    private static final byte[] _defaultIvBytes = new byte[]{81, 101, 34, 35, 100, 5, 106, -66, 81, 101, 34, 35, 100, 5, 106, -66};
    private Key _key;
    private IvParameterSpec _iv;

    public EncryptorImpl(boolean defaultKey) {
        if (defaultKey) {
            this._key = new SecretKeySpec(_defaultKeyBytes, ALGORITHM);
            this._iv = new IvParameterSpec(_defaultIvBytes);
        } else {
            try {
                this._key = KeyGenerator.getInstance(ALGORITHM).generateKey();
                this._iv = new IvParameterSpec(_defaultIvBytes);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public byte[] decrypt(byte[] bytes) {
        try {
            Cipher cipher = Cipher.getInstance(FULL_ALGORITHM);
            cipher.init(2, this._key, this._iv);
            return cipher.doFinal(bytes);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] encrypt(byte[] bytes) {
        try {
            Cipher cipher = Cipher.getInstance(FULL_ALGORITHM);
            cipher.init(1, this._key, this._iv);
            return cipher.doFinal(bytes);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

