/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.framework.impl.api.ObjectStreamHandler;
import org.identityconnectors.framework.impl.api.StreamHandlerUtil;
import org.identityconnectors.framework.impl.api.local.ThreadClassLoaderManager;

public class ThreadClassLoaderManagerProxy
implements InvocationHandler {
    private final ClassLoader _bundleClassLoader;
    private final Object _target;

    public ThreadClassLoaderManagerProxy(ClassLoader bundleClassLoader, Object target) {
        Assertions.nullCheck((Object)bundleClassLoader, (String)"bundleClassLoader");
        Assertions.nullCheck((Object)target, (String)"target");
        this._bundleClassLoader = bundleClassLoader;
        this._target = target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        ClassLoader applicationClassLoader = ThreadClassLoaderManager.getInstance().getCurrentClassLoader();
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            if (!StreamHandlerUtil.isAdaptableToObjectStreamHandler(paramType) || arguments[i] == null) continue;
            ObjectStreamHandler rawHandler = StreamHandlerUtil.adaptToObjectStreamHandler(paramType, arguments[i]);
            ApplicationClassLoaderHandler appHandler = new ApplicationClassLoaderHandler(applicationClassLoader, rawHandler);
            arguments[i] = StreamHandlerUtil.adaptFromObjectStreamHandler(paramTypes[i], appHandler);
        }
        ThreadClassLoaderManager.getInstance().pushClassLoader(this._bundleClassLoader);
        try {
            Object i = method.invoke(this._target, arguments);
            return i;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            ThreadClassLoaderManager.getInstance().popClassLoader();
        }
    }

    private static class ApplicationClassLoaderHandler
    implements ObjectStreamHandler {
        private final ClassLoader _applicationClassLoader;
        private final ObjectStreamHandler _target;

        public ApplicationClassLoaderHandler(ClassLoader applicationClassLoader, ObjectStreamHandler target) {
            Assertions.nullCheck((Object)applicationClassLoader, (String)"applicationClassLoader");
            Assertions.nullCheck((Object)target, (String)"target");
            this._applicationClassLoader = applicationClassLoader;
            this._target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handle(Object object) {
            ThreadClassLoaderManager.getInstance().pushClassLoader(this._applicationClassLoader);
            try {
                boolean bl = this._target.handle(object);
                return bl;
            }
            finally {
                ThreadClassLoaderManager.getInstance().popClassLoader();
            }
        }
    }
}

