/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.schedule.impl;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.state.schedule.ScheduleIdList;
import com.hedera.hapi.node.state.schedule.ScheduleList;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;

public final class ScheduleStoreUtility {
    private ScheduleStoreUtility() {
    }

    public static Bytes calculateBytesHash(@NonNull Schedule schedule) {
        Objects.requireNonNull(schedule);
        Hasher hasher = Hashing.sha256().newHasher();
        hasher.putString((CharSequence)schedule.memo(), StandardCharsets.UTF_8);
        if (schedule.adminKey() != null) {
            ScheduleStoreUtility.addToHash(hasher, schedule.adminKey());
        }
        if (schedule.scheduledTransaction() != null) {
            ScheduleStoreUtility.addToHash(hasher, schedule.scheduledTransaction());
        }
        hasher.putLong(schedule.providedExpirationSecond());
        hasher.putBoolean(schedule.waitForExpiry());
        return Bytes.wrap((byte[])hasher.hash().asBytes());
    }

    private static void addToHash(Hasher hasher, Key keyToAdd) {
        byte[] keyBytes = Key.PROTOBUF.toBytes((Object)keyToAdd).toByteArray();
        hasher.putInt(keyBytes.length);
        hasher.putBytes(keyBytes);
    }

    private static void addToHash(Hasher hasher, SchedulableTransactionBody transactionToAdd) {
        byte[] bytes = SchedulableTransactionBody.PROTOBUF.toBytes((Object)transactionToAdd).toByteArray();
        hasher.putInt(bytes.length);
        hasher.putBytes(bytes);
    }

    private static boolean isScheduleInList(ScheduleID scheduleId, ScheduleList scheduleList) {
        return scheduleList.schedules().stream().anyMatch(s -> s.scheduleIdOrThrow().equals((Object)scheduleId));
    }

    private static boolean isScheduleIdInList(ScheduleID scheduleId, ScheduleIdList scheduleIdList) {
        return scheduleIdList.scheduleIds().stream().anyMatch(id -> id.equals((Object)scheduleId));
    }

    @NonNull
    static ScheduleList addOrReplace(Schedule schedule, @Nullable ScheduleList scheduleList) {
        if (scheduleList == null) {
            return new ScheduleList(Collections.singletonList(schedule));
        }
        ScheduleList.Builder newScheduleList = scheduleList.copyBuilder();
        ScheduleID scheduleId = schedule.scheduleIdOrThrow();
        ArrayList<Schedule> schedules = new ArrayList<Schedule>(scheduleList.schedules());
        if (!ScheduleStoreUtility.isScheduleInList(scheduleId, scheduleList)) {
            schedules.add(schedule);
        } else {
            for (int i = 0; i < schedules.size(); ++i) {
                Schedule existingSchedule = (Schedule)schedules.get(i);
                if (!existingSchedule.scheduleIdOrThrow().equals((Object)scheduleId)) continue;
                schedules.set(i, schedule);
            }
        }
        return newScheduleList.schedules(schedules).build();
    }

    @NonNull
    static ScheduleIdList add(ScheduleID scheduleId, @Nullable ScheduleIdList scheduleIdList) {
        if (scheduleIdList == null) {
            return new ScheduleIdList(Collections.singletonList(scheduleId));
        }
        ScheduleIdList.Builder newScheduleIdList = scheduleIdList.copyBuilder();
        ArrayList<ScheduleID> scheduleIds = new ArrayList<ScheduleID>(scheduleIdList.scheduleIds());
        if (!ScheduleStoreUtility.isScheduleIdInList(scheduleId, scheduleIdList)) {
            scheduleIds.add(scheduleId);
        }
        return newScheduleIdList.scheduleIds(scheduleIds).build();
    }
}

