/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.schedule.impl.handlers;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.scheduled.ScheduleDeleteTransactionBody;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.schedule.ScheduleOpsUsage;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hedera.node.app.service.schedule.ReadableScheduleStore;
import com.hedera.node.app.service.schedule.ScheduleStreamBuilder;
import com.hedera.node.app.service.schedule.WritableScheduleStore;
import com.hedera.node.app.service.schedule.impl.handlers.AbstractScheduleHandler;
import com.hedera.node.app.service.schedule.impl.handlers.ScheduleFeeCharging;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.signatures.SignatureVerification;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.data.SchedulingConfig;
import com.hederahashgraph.api.proto.java.FeeData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ScheduleDeleteHandler
extends AbstractScheduleHandler
implements TransactionHandler {
    private final ScheduleOpsUsage scheduleOpsUsage = new ScheduleOpsUsage();

    @Inject
    public ScheduleDeleteHandler(@NonNull ScheduleFeeCharging feeCharging) {
        super(feeCharging);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody body = context.body();
        Objects.requireNonNull(body);
        PreCheckException.validateTruePreCheck((boolean)body.hasScheduleDelete(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        ScheduleDeleteTransactionBody op = body.scheduleDeleteOrThrow();
        PreCheckException.validateTruePreCheck((boolean)op.hasScheduleID(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_SCHEDULE_ID);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        ReadableScheduleStore scheduleStore = (ReadableScheduleStore)context.createStore(ReadableScheduleStore.class);
        SchedulingConfig schedulingConfig = (SchedulingConfig)context.configuration().getConfigData(SchedulingConfig.class);
        boolean isLongTermEnabled = schedulingConfig.longTermEnabled();
        ScheduleDeleteTransactionBody op = context.body().scheduleDeleteOrThrow();
        Schedule schedule = this.getValidated(op.scheduleIDOrThrow(), scheduleStore, isLongTermEnabled);
        HandleException.validateFalse((boolean)schedule.deleted(), (ResponseCodeEnum)ResponseCodeEnum.SCHEDULE_ALREADY_DELETED);
        HandleException.validateFalse((boolean)schedule.executed(), (ResponseCodeEnum)ResponseCodeEnum.SCHEDULE_ALREADY_EXECUTED);
        PreCheckException.validateTruePreCheck((boolean)schedule.hasAdminKey(), (ResponseCodeEnum)ResponseCodeEnum.SCHEDULE_IS_IMMUTABLE);
        context.requireKey(schedule.adminKeyOrThrow());
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        WritableScheduleStore scheduleStore = (WritableScheduleStore)context.storeFactory().writableStore(WritableScheduleStore.class);
        TransactionBody body = context.body();
        ScheduleDeleteTransactionBody op = body.scheduleDeleteOrThrow();
        ScheduleID scheduleId = op.scheduleIDOrThrow();
        SchedulingConfig schedulingConfig = (SchedulingConfig)context.configuration().getConfigData(SchedulingConfig.class);
        boolean isLongTermEnabled = schedulingConfig.longTermEnabled();
        Schedule schedule = this.revalidateOrThrow(scheduleId, (ReadableScheduleStore)scheduleStore, isLongTermEnabled);
        HandleException.validateTrue((boolean)schedule.hasAdminKey(), (ResponseCodeEnum)ResponseCodeEnum.SCHEDULE_IS_IMMUTABLE);
        SignatureVerification verificationResult = context.keyVerifier().verificationFor(schedule.adminKeyOrThrow());
        HandleException.validateTrue((boolean)verificationResult.passed(), (ResponseCodeEnum)ResponseCodeEnum.UNAUTHORIZED);
        scheduleStore.delete(scheduleId, context.consensusNow());
        ((ScheduleStreamBuilder)context.savepointStack().getBaseBuilder(ScheduleStreamBuilder.class)).scheduleID(scheduleId);
    }

    @NonNull
    protected Schedule revalidateOrThrow(@NonNull ScheduleID scheduleId, @NonNull ReadableScheduleStore scheduleStore, boolean isLongTermEnabled) throws HandleException {
        Objects.requireNonNull(scheduleId);
        Objects.requireNonNull(scheduleStore);
        try {
            Schedule schedule = this.getValidated(scheduleId, scheduleStore, isLongTermEnabled);
            HandleException.validateFalse((boolean)schedule.deleted(), (ResponseCodeEnum)ResponseCodeEnum.SCHEDULE_ALREADY_DELETED);
            HandleException.validateFalse((boolean)schedule.executed(), (ResponseCodeEnum)ResponseCodeEnum.SCHEDULE_ALREADY_EXECUTED);
            return schedule;
        }
        catch (PreCheckException e) {
            throw new HandleException(e.responseCode());
        }
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        ReadableScheduleStore scheduleStore = (ReadableScheduleStore)feeContext.readableStore(ReadableScheduleStore.class);
        TransactionBody op = feeContext.body();
        Schedule schedule = scheduleStore.get(op.scheduleDeleteOrElse(ScheduleDeleteTransactionBody.DEFAULT).scheduleIDOrElse(ScheduleID.DEFAULT));
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).legacyCalculate(sigValueObj -> this.usageGiven(CommonPbjConverters.fromPbj((TransactionBody)op), (SigValueObj)sigValueObj, schedule, ((LedgerConfig)feeContext.configuration().getConfigData(LedgerConfig.class)).scheduleTxExpiryTimeSecs()));
    }

    private FeeData usageGiven(@NonNull com.hederahashgraph.api.proto.java.TransactionBody txn, @NonNull SigValueObj svo, @Nullable Schedule schedule, long scheduledTxExpiryTimeSecs) {
        SigUsage sigUsage = new SigUsage(svo.getTotalSigCount(), svo.getSignatureSize(), svo.getPayerAcctSigCount());
        if (schedule != null) {
            return this.scheduleOpsUsage.scheduleDeleteUsage(txn, sigUsage, schedule.calculatedExpirationSecond());
        }
        long latestExpiry = txn.getTransactionID().getTransactionValidStart().getSeconds() + scheduledTxExpiryTimeSecs;
        return this.scheduleOpsUsage.scheduleDeleteUsage(txn, sigUsage, latestExpiry);
    }
}

