/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.token.TokenDissociateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.EstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.SingletonEstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.TxnUsageEstimator;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoOpsUsage;
import com.hedera.node.app.hapi.fees.usage.token.TokenDissociateUsage;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableTokenRelationStore;
import com.hedera.node.app.service.token.impl.handlers.BaseCryptoHandler;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.service.token.impl.util.TokenRelListCalculator;
import com.hedera.node.app.service.token.impl.validators.TokenListChecks;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hederahashgraph.api.proto.java.FeeData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenDissociateFromAccountHandler
implements TransactionHandler {
    private static final TokenID NO_ASSOCIATED_TOKENS = TokenID.newBuilder().tokenNum(-1L).build();

    @Inject
    public TokenDissociateFromAccountHandler() {
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody trxBody = context.body();
        TokenDissociateTransactionBody op = trxBody.tokenDissociateOrThrow();
        AccountID target = op.accountOrElse(AccountID.DEFAULT);
        context.requireKeyOrThrow(target, ResponseCodeEnum.INVALID_ACCOUNT_ID);
    }

    public void handle(@NonNull HandleContext context) {
        Objects.requireNonNull(context);
        StoreFactory storeFactory = context.storeFactory();
        WritableAccountStore accountStore = (WritableAccountStore)storeFactory.writableStore(WritableAccountStore.class);
        ReadableTokenStore tokenStore = (ReadableTokenStore)storeFactory.readableStore(ReadableTokenStore.class);
        WritableTokenRelationStore tokenRelStore = (WritableTokenRelationStore)storeFactory.writableStore(WritableTokenRelationStore.class);
        ExpiryValidator expiryValidator = context.expiryValidator();
        TransactionBody txn = context.body();
        TokenDissociateTransactionBody op = txn.tokenDissociateOrThrow();
        List tokenIds = op.tokens();
        ValidatedResult validated = this.validateSemantics(op.accountOrThrow(), tokenIds, accountStore, tokenStore, tokenRelStore, expiryValidator);
        long numNftsToSubtract = 0L;
        int numAutoAssociationsToSubtract = 0;
        int numAssociationsToSubtract = 0;
        int numPositiveBalancesToSubtract = 0;
        Account account = validated.account();
        ArrayList<TokenRelation> tokenRelsToRemove = new ArrayList<TokenRelation>();
        ArrayList<TokenRelation> treasuryBalancesToUpdate = new ArrayList<TokenRelation>();
        for (Dissociation dissociation : validated.dissociations()) {
            TokenRelation tokenRel = dissociation.tokenRel();
            long tokenRelBalance = tokenRel.balance();
            Token token = dissociation.token();
            if (token == null || token.deleted()) {
                if (token != null && token.tokenType() == TokenType.NON_FUNGIBLE_UNIQUE) {
                    numNftsToSubtract += tokenRelBalance;
                }
            } else {
                HandleException.validateFalse((token.treasuryAccountId() != null && token.treasuryAccountId().equals((Object)tokenRel.accountId()) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_IS_TREASURY);
                HandleException.validateFalse((boolean)tokenRel.frozen(), (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_FROZEN_FOR_TOKEN);
                if (tokenRelBalance > 0L) {
                    if (token.tokenType() == TokenType.NON_FUNGIBLE_UNIQUE) {
                        throw new HandleException(ResponseCodeEnum.ACCOUNT_STILL_OWNS_NFTS);
                    }
                    throw new HandleException(ResponseCodeEnum.TRANSACTION_REQUIRES_ZERO_TOKEN_BALANCES);
                }
            }
            TokenRelation updatedBalanceTokenRel = tokenRel.copyBuilder().balance(0L).build();
            tokenRelsToRemove.add(updatedBalanceTokenRel);
            if (tokenRel.automaticAssociation()) {
                ++numAutoAssociationsToSubtract;
            }
            if (tokenRel.balance() != 0L) {
                ++numPositiveBalancesToSubtract;
            }
            ++numAssociationsToSubtract;
        }
        TokenRelListCalculator.TokenRelsRemovalResult updatedTokenRels = new TokenRelListCalculator(tokenRelStore).removeTokenRels(account, tokenRelsToRemove);
        TokenID newHeadTokenId = updatedTokenRels.updatedHeadTokenId();
        Account updatedAcct = account.copyBuilder().numberOwnedNfts(account.numberOwnedNfts() - numNftsToSubtract).usedAutoAssociations(account.usedAutoAssociations() - numAutoAssociationsToSubtract).numberAssociations(account.numberAssociations() - numAssociationsToSubtract).numberPositiveBalances(account.numberPositiveBalances() - numPositiveBalancesToSubtract).headTokenId(newHeadTokenId == null ? NO_ASSOCIATED_TOKENS : newHeadTokenId).build();
        accountStore.put(updatedAcct);
        updatedTokenRels.updatedTokenRelsStillInChain().forEach(tokenRelStore::put);
        tokenRelsToRemove.forEach(tokenRelStore::remove);
        treasuryBalancesToUpdate.forEach(tokenRelStore::put);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        TokenDissociateTransactionBody op = txn.tokenDissociateOrThrow();
        PreCheckException.validateTruePreCheck((boolean)BaseCryptoHandler.hasAccountNumOrAlias(op.account()), (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
        PreCheckException.validateFalsePreCheck((boolean)op.tokens().contains(TokenID.DEFAULT), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
        PreCheckException.validateTruePreCheck((!TokenListChecks.repeatsItself(op.tokens()) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_ID_REPEATED_IN_TOKEN_LIST);
    }

    @NonNull
    private ValidatedResult validateSemantics(@NonNull AccountID accountId, @NonNull List<TokenID> tokenIds, @NonNull WritableAccountStore accountStore, @NonNull ReadableTokenStore tokenStore, @NonNull WritableTokenRelationStore tokenRelStore, @NonNull ExpiryValidator expiryValidator) {
        Account acct = TokenHandlerHelper.getIfUsable(accountId, accountStore, expiryValidator, ResponseCodeEnum.INVALID_ACCOUNT_ID);
        ArrayList<Dissociation> dissociations = new ArrayList<Dissociation>();
        for (TokenID tokenId : tokenIds) {
            TokenRelation dissociatedTokenTreasuryRel;
            TokenRelation tokenRel = tokenRelStore.get(accountId, tokenId);
            HandleException.validateTrue((tokenRel != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_ACCOUNT);
            HandleException.validateTrue((tokenId.tokenNum() > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
            Token possiblyUnusableToken = tokenStore.get(tokenId);
            if (possiblyUnusableToken != null) {
                HandleException.validateFalse((boolean)possiblyUnusableToken.paused(), (ResponseCodeEnum)ResponseCodeEnum.TOKEN_IS_PAUSED);
                if (!possiblyUnusableToken.deleted() && possiblyUnusableToken.treasuryAccountId() != null) {
                    AccountID tokenTreasuryAcct = possiblyUnusableToken.treasuryAccountId();
                    dissociatedTokenTreasuryRel = tokenRelStore.get(tokenTreasuryAcct, tokenId);
                } else {
                    dissociatedTokenTreasuryRel = null;
                }
            } else {
                dissociatedTokenTreasuryRel = null;
            }
            Dissociation dissociation = new Dissociation(possiblyUnusableToken, tokenRel, acct, dissociatedTokenTreasuryRel);
            dissociations.add(dissociation);
        }
        return new ValidatedResult(acct, dissociations);
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        TransactionBody body = feeContext.body();
        TokenDissociateTransactionBody op = body.tokenDissociateOrThrow();
        AccountID accountId = op.accountOrThrow();
        ReadableAccountStore readableAccountStore = (ReadableAccountStore)feeContext.readableStore(ReadableAccountStore.class);
        Account account = readableAccountStore.getAccountById(accountId);
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).legacyCalculate(sigValueObj -> this.usageGiven(CommonPbjConverters.fromPbj((TransactionBody)body), (SigValueObj)sigValueObj, account));
    }

    public FeeData usageGiven(com.hederahashgraph.api.proto.java.TransactionBody txn, SigValueObj svo, Account account) {
        if (account == null) {
            return Fees.CONSTANT_FEE_DATA;
        }
        SigUsage sigUsage = new SigUsage(svo.getTotalSigCount(), svo.getSignatureSize(), svo.getPayerAcctSigCount());
        TokenDissociateUsage estimate = TokenDissociateUsage.newEstimate((com.hederahashgraph.api.proto.java.TransactionBody)txn, (TxnUsageEstimator)CryptoOpsUsage.txnEstimateFactory.get(sigUsage, txn, (EstimatorUtils)SingletonEstimatorUtils.ESTIMATOR_UTILS));
        return estimate.get();
    }

    private record ValidatedResult(@NonNull Account account, @NonNull List<Dissociation> dissociations) {
    }

    private record Dissociation(@Nullable Token token, @NonNull TokenRelation tokenRel, @NonNull Account acct, @Nullable TokenRelation treasuryTokenRel) {
    }
}

