/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ResponseHeader;
import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenFreezeStatus;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenKycStatus;
import com.hedera.hapi.node.base.TokenPauseStatus;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.TokenGetInfoQuery;
import com.hedera.hapi.node.token.TokenGetInfoResponse;
import com.hedera.hapi.node.token.TokenInfo;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.node.app.hapi.fees.usage.token.TokenGetInfoUsage;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.PaidQueryHandler;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.config.data.LedgerConfig;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.Query;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenGetInfoHandler
extends PaidQueryHandler {
    @Inject
    public TokenGetInfoHandler() {
    }

    public QueryHeader extractHeader(@NonNull com.hedera.hapi.node.transaction.Query query) {
        Objects.requireNonNull(query);
        return query.tokenGetInfoOrThrow().header();
    }

    public Response createEmptyResponse(@NonNull ResponseHeader header) {
        Objects.requireNonNull(header);
        TokenGetInfoResponse.Builder response = TokenGetInfoResponse.newBuilder().header(Objects.requireNonNull(header));
        return Response.newBuilder().tokenGetInfo(response).build();
    }

    public void validate(@NonNull QueryContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        com.hedera.hapi.node.transaction.Query query = context.query();
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.createStore(ReadableTokenStore.class);
        TokenGetInfoQuery op = query.tokenGetInfoOrThrow();
        PreCheckException.validateTruePreCheck((boolean)op.hasToken(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
        Token token = tokenStore.get(Objects.requireNonNull(op.token()));
        PreCheckException.validateFalsePreCheck((token == null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
    }

    public Response findResponse(@NonNull QueryContext context, @NonNull ResponseHeader header) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(header);
        com.hedera.hapi.node.transaction.Query query = context.query();
        LedgerConfig config = (LedgerConfig)context.configuration().getConfigData(LedgerConfig.class);
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.createStore(ReadableTokenStore.class);
        TokenGetInfoQuery op = query.tokenGetInfoOrThrow();
        TokenGetInfoResponse.Builder response = TokenGetInfoResponse.newBuilder();
        TokenID tokenID = op.tokenOrElse(TokenID.DEFAULT);
        ResponseType responseType = op.headerOrElse(QueryHeader.DEFAULT).responseType();
        response.header(header);
        if (header.nodeTransactionPrecheckCode() == ResponseCodeEnum.OK && responseType != ResponseType.COST_ANSWER) {
            Optional<TokenInfo> optionalInfo = this.infoForToken(tokenID, tokenStore, config);
            if (optionalInfo.isPresent()) {
                response.tokenInfo(optionalInfo.get());
            } else {
                response.header(ResponseHeader.newBuilder().nodeTransactionPrecheckCode(ResponseCodeEnum.INVALID_TOKEN_ID).cost(0L));
            }
        }
        return Response.newBuilder().tokenGetInfo(response).build();
    }

    private Optional<TokenInfo> infoForToken(@NonNull TokenID tokenID, @NonNull ReadableTokenStore readableTokenStore, @NonNull LedgerConfig config) {
        Objects.requireNonNull(tokenID);
        Objects.requireNonNull(readableTokenStore);
        Objects.requireNonNull(config);
        Token token = readableTokenStore.get(tokenID);
        if (token == null) {
            return Optional.empty();
        }
        TokenInfo.Builder info = TokenInfo.newBuilder();
        info.ledgerId(config.id());
        info.tokenType(token.tokenType());
        info.supplyType(token.supplyType());
        info.tokenId(tokenID);
        info.deleted(token.deleted());
        info.symbol(token.symbol());
        info.name(token.name());
        info.memo(token.memo());
        info.treasury(token.treasuryAccountId());
        info.totalSupply(token.totalSupply());
        info.maxSupply(token.maxSupply());
        info.decimals(token.decimals());
        info.expiry(Timestamp.newBuilder().seconds(token.expirationSecond()));
        if (!KeyUtils.isEmpty((Key)token.adminKey())) {
            info.adminKey(token.adminKey());
        }
        if (!KeyUtils.isEmpty((Key)token.supplyKey())) {
            info.supplyKey(token.supplyKey());
        }
        if (!KeyUtils.isEmpty((Key)token.wipeKey())) {
            info.wipeKey(token.wipeKey());
        }
        if (!KeyUtils.isEmpty((Key)token.feeScheduleKey())) {
            info.feeScheduleKey(token.feeScheduleKey());
        }
        if (token.autoRenewAccountId() != null) {
            info.autoRenewAccount(token.autoRenewAccountId());
            info.autoRenewPeriod(Duration.newBuilder().seconds(token.autoRenewSeconds()));
        }
        if (!KeyUtils.isEmpty((Key)token.freezeKey())) {
            info.freezeKey(token.freezeKey());
            info.defaultFreezeStatus(token.accountsFrozenByDefault() ? TokenFreezeStatus.FROZEN : TokenFreezeStatus.UNFROZEN);
        } else {
            info.defaultFreezeStatus(TokenFreezeStatus.FREEZE_NOT_APPLICABLE);
        }
        if (!KeyUtils.isEmpty((Key)token.kycKey())) {
            info.kycKey(token.kycKey());
            info.defaultKycStatus(token.accountsKycGrantedByDefault() ? TokenKycStatus.GRANTED : TokenKycStatus.REVOKED);
        } else {
            info.defaultKycStatus(TokenKycStatus.KYC_NOT_APPLICABLE);
        }
        if (!KeyUtils.isEmpty((Key)token.pauseKey())) {
            info.pauseKey(token.pauseKey());
            info.pauseStatus(token.paused() ? TokenPauseStatus.PAUSED : TokenPauseStatus.UNPAUSED);
        } else {
            info.pauseStatus(TokenPauseStatus.PAUSE_NOT_APPLICABLE);
        }
        if (!KeyUtils.isEmpty((Key)token.metadataKey())) {
            info.metadataKey(token.metadataKey());
        }
        info.metadata(token.metadata());
        info.customFees(token.customFees());
        return Optional.of(info.build());
    }

    @NonNull
    public Fees computeFees(@NonNull QueryContext queryContext) {
        com.hedera.hapi.node.transaction.Query query = queryContext.query();
        ReadableTokenStore tokenStore = (ReadableTokenStore)queryContext.createStore(ReadableTokenStore.class);
        TokenGetInfoQuery op = query.tokenGetInfoOrThrow();
        TokenID tokenId = op.tokenOrElse(TokenID.DEFAULT);
        Token token = tokenStore.get(tokenId);
        return queryContext.feeCalculator().legacyCalculate(sigValueObj -> this.usageGiven(CommonPbjConverters.fromPbj((com.hedera.hapi.node.transaction.Query)query), token));
    }

    private FeeData usageGiven(Query query, Token token) {
        if (token != null) {
            TokenGetInfoUsage estimate = TokenGetInfoUsage.newEstimate((Query)query).givenCurrentAdminKey(token.hasAdminKey() ? Optional.of(CommonPbjConverters.fromPbj((Key)token.adminKeyOrThrow())) : Optional.empty()).givenCurrentFreezeKey(token.hasFreezeKey() ? Optional.of(CommonPbjConverters.fromPbj((Key)token.freezeKeyOrThrow())) : Optional.empty()).givenCurrentWipeKey(token.hasWipeKey() ? Optional.of(CommonPbjConverters.fromPbj((Key)token.wipeKeyOrThrow())) : Optional.empty()).givenCurrentSupplyKey(token.hasSupplyKey() ? Optional.of(CommonPbjConverters.fromPbj((Key)token.supplyKeyOrThrow())) : Optional.empty()).givenCurrentKycKey(token.hasKycKey() ? Optional.of(CommonPbjConverters.fromPbj((Key)token.kycKeyOrThrow())) : Optional.empty()).givenCurrentPauseKey(token.hasPauseKey() ? Optional.of(CommonPbjConverters.fromPbj((Key)token.pauseKeyOrThrow())) : Optional.empty()).givenCurrentMetadataKey(token.hasMetadataKey() ? Optional.of(CommonPbjConverters.fromPbj((Key)token.metadataKeyOrThrow())) : Optional.empty()).givenCurrentName(token.name()).givenCurrentMemo(token.memo()).givenCurrentSymbol(token.symbol());
            if (token.hasAutoRenewAccountId()) {
                estimate.givenCurrentlyUsingAutoRenewAccount();
            }
            return estimate.get();
        }
        return Fees.CONSTANT_FEE_DATA;
    }
}

