/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.staking;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.StakingNodeInfo;
import com.hedera.node.app.service.token.ReadableNetworkStakingRewardsStore;
import com.hedera.node.app.service.token.api.StakingRewardsApi;
import com.hedera.node.app.service.token.impl.WritableStakingInfoStore;
import com.hedera.node.app.service.token.impl.handlers.staking.StakePeriodManager;
import com.hedera.node.app.service.token.impl.handlers.staking.StakeRewardCalculator;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class StakeRewardCalculatorImpl
implements StakeRewardCalculator {
    private final StakePeriodManager stakePeriodManager;

    @Inject
    public StakeRewardCalculatorImpl(@NonNull StakePeriodManager stakePeriodManager) {
        this.stakePeriodManager = stakePeriodManager;
    }

    @Override
    public long computePendingReward(@NonNull Account account, @NonNull WritableStakingInfoStore stakingInfoStore, @NonNull ReadableNetworkStakingRewardsStore rewardsStore, @NonNull Instant consensusNow) {
        long effectiveStart = this.stakePeriodManager.effectivePeriod(account.stakePeriodStart());
        if (!this.stakePeriodManager.isRewardable(effectiveStart, rewardsStore)) {
            return 0L;
        }
        Long nodeId = account.stakedNodeIdOrThrow();
        StakingNodeInfo stakingInfo = stakingInfoStore.getOriginalValue(nodeId);
        if (stakingInfo != null && stakingInfo.deleted()) {
            return 0L;
        }
        long rewardOffered = StakeRewardCalculatorImpl.computeRewardFromDetails(account, stakingInfo, this.stakePeriodManager.currentStakePeriod(), effectiveStart);
        return account.declineReward() ? 0L : rewardOffered;
    }

    @Override
    public long estimatePendingRewards(@NonNull Account account, @Nullable StakingNodeInfo nodeStakingInfo, @NonNull ReadableNetworkStakingRewardsStore rewardsStore) {
        long effectiveStart = this.stakePeriodManager.effectivePeriod(account.stakePeriodStart());
        if (!this.stakePeriodManager.isEstimatedRewardable(effectiveStart, rewardsStore) || nodeStakingInfo != null && nodeStakingInfo.deleted()) {
            return 0L;
        }
        long rewardOffered = StakeRewardCalculatorImpl.computeRewardFromDetails(account, nodeStakingInfo, this.stakePeriodManager.estimatedCurrentStakePeriod(), effectiveStart);
        return account.declineReward() ? 0L : rewardOffered;
    }

    @Override
    public long epochSecondAtStartOfPeriod(long stakePeriod) {
        return this.stakePeriodManager.epochSecondAtStartOfPeriod(stakePeriod);
    }

    @VisibleForTesting
    public static long computeRewardFromDetails(@NonNull Account account, @Nullable StakingNodeInfo nodeStakingInfo, long currentStakePeriod, long effectiveStart) {
        return StakingRewardsApi.computeRewardFromDetails((Account)account, (StakingNodeInfo)nodeStakingInfo, (long)currentStakePeriod, (long)effectiveStart);
    }
}

