/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenAssociation;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.AccountCryptoAllowance;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.node.app.service.token.AliasUtils;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.handlers.transfer.AutoAccountCreator;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferContext;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.ItemizedAssessedFee;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TransferContextImpl
implements TransferContext {
    private final WritableAccountStore accountStore;
    private final AutoAccountCreator autoAccountCreator;
    private final HandleContext context;
    private int numAutoCreations;
    private int numLazyCreations;
    private final Map<Bytes, AccountID> resolutions = new LinkedHashMap<Bytes, AccountID>();
    private final List<TokenAssociation> automaticAssociations = new ArrayList<TokenAssociation>();
    private final List<ItemizedAssessedFee> itemizedAssessedFees = new ArrayList<ItemizedAssessedFee>();
    private CryptoTransferTransactionBody syntheticBody = null;
    private final boolean enforceMonoServiceRestrictionsOnAutoCreationCustomFeePayments;

    public TransferContextImpl(HandleContext context) {
        this(context, true);
    }

    public TransferContextImpl(HandleContext context, boolean enforceMonoServiceRestrictionsOnAutoCreationCustomFeePayments) {
        this.context = context;
        this.accountStore = (WritableAccountStore)context.storeFactory().writableStore(WritableAccountStore.class);
        this.autoAccountCreator = new AutoAccountCreator(context);
        this.enforceMonoServiceRestrictionsOnAutoCreationCustomFeePayments = enforceMonoServiceRestrictionsOnAutoCreationCustomFeePayments;
    }

    public TransferContextImpl(HandleContext context, CryptoTransferTransactionBody syntheticBody, boolean enforceMonoServiceRestrictionsOnAutoCreationCustomFeePayments) {
        this.context = context;
        this.syntheticBody = syntheticBody;
        this.accountStore = (WritableAccountStore)context.storeFactory().writableStore(WritableAccountStore.class);
        this.autoAccountCreator = new AutoAccountCreator(context);
        this.enforceMonoServiceRestrictionsOnAutoCreationCustomFeePayments = enforceMonoServiceRestrictionsOnAutoCreationCustomFeePayments;
    }

    @Override
    public AccountID getFromAlias(AccountID aliasedId) {
        Account account = this.accountStore.getAliasedAccountById(aliasedId);
        if (account != null) {
            AccountID id = account.accountId();
            this.resolutions.put(aliasedId.alias(), id);
            return id;
        }
        return null;
    }

    @Override
    public void createFromAlias(Bytes alias, int reqMaxAutoAssociations) {
        if (AliasUtils.isOfEvmAddressSize((Bytes)alias)) {
            ++this.numLazyCreations;
        } else if (AliasUtils.isSerializedProtoKey((Bytes)alias)) {
            ++this.numAutoCreations;
        } else {
            throw new HandleException(ResponseCodeEnum.INVALID_ALIAS_KEY);
        }
        AccountID createdAccount = this.autoAccountCreator.create(alias, reqMaxAutoAssociations);
        this.resolutions.put(alias, createdAccount);
    }

    @Override
    public HandleContext getHandleContext() {
        return this.context;
    }

    @Override
    public int numOfAutoCreations() {
        return this.numAutoCreations;
    }

    @Override
    public void chargeExtraFeeToHapiPayer(long amount) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Map<Bytes, AccountID> resolutions() {
        return this.resolutions;
    }

    @Override
    public int numOfLazyCreations() {
        return this.numLazyCreations;
    }

    @Override
    public void addToAutomaticAssociations(TokenAssociation newAssociation) {
        this.automaticAssociations.add(newAssociation);
    }

    public List<TokenAssociation> getAutomaticAssociations() {
        return this.automaticAssociations;
    }

    @Override
    public void addToAssessedCustomFee(ItemizedAssessedFee assessedCustomFee) {
        this.itemizedAssessedFees.add(assessedCustomFee);
    }

    @Override
    public List<AssessedCustomFee> getAssessedCustomFees() {
        return new ArrayList<AssessedCustomFee>(this.itemizedAssessedFees.stream().map(ItemizedAssessedFee::assessedCustomFee).toList());
    }

    @Override
    public List<ItemizedAssessedFee> getItemizedAssessedFees() {
        return this.itemizedAssessedFees;
    }

    @Override
    public boolean isEnforceMonoServiceRestrictionsOnAutoCreationCustomFeePayments() {
        return this.enforceMonoServiceRestrictionsOnAutoCreationCustomFeePayments;
    }

    @Override
    public void validateHbarAllowances() {
        AccountID topLevelPayer = this.context.payer();
        CryptoTransferTransactionBody body = this.syntheticBody != null ? this.syntheticBody : this.context.body().cryptoTransferOrThrow();
        for (AccountAmount aa : body.transfersOrElse(TransferList.DEFAULT).accountAmounts()) {
            if (!aa.isApproval() || aa.amount() >= 0L) continue;
            this.maybeValidateHbarAllowance(this.accountStore.getAliasedAccountById(aa.accountIDOrElse(AccountID.DEFAULT)), topLevelPayer, aa.amount());
        }
    }

    private void maybeValidateHbarAllowance(@Nullable Account account, @NonNull AccountID topLevelPayer, long amount) {
        if (account != null) {
            List cryptoAllowances = account.cryptoAllowances();
            for (AccountCryptoAllowance allowance : cryptoAllowances) {
                if (!topLevelPayer.equals((Object)allowance.spenderId())) continue;
                long newAllowanceAmount = allowance.amount() + amount;
                HandleException.validateTrue((newAllowanceAmount >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.AMOUNT_EXCEEDS_ALLOWANCE);
                return;
            }
            throw new HandleException(ResponseCodeEnum.SPENDER_DOES_NOT_HAVE_ALLOWANCE);
        }
    }
}

