/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.util;

import com.hedera.hapi.node.base.PendingAirdropId;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.AccountPendingAirdrop;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableAirdropStore;
import com.hedera.node.app.spi.workflows.HandleException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class PendingAirdropUpdater {
    private static final Logger log = LogManager.getLogger(PendingAirdropUpdater.class);

    @Inject
    public PendingAirdropUpdater() {
    }

    public void removePendingAirdrops(@NonNull Set<PendingAirdropId> airdropsToRemove, @NonNull WritableAirdropStore pendingAirdropStore, @NonNull WritableAccountStore accountStore) {
        for (PendingAirdropId id : airdropsToRemove) {
            this.removePendingAirdrops(id, pendingAirdropStore, accountStore);
        }
    }

    private void removePendingAirdrops(@NonNull PendingAirdropId airdropId, @NonNull WritableAirdropStore pendingAirdropStore, @NonNull WritableAccountStore accountStore) {
        Account senderAccount;
        AccountPendingAirdrop updatedAirdrop;
        AccountPendingAirdrop airdrop = pendingAirdropStore.get(airdropId);
        HandleException.validateTrue((airdrop != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_PENDING_AIRDROP_ID);
        PendingAirdropId prevAirdropId = airdrop.previousAirdrop();
        PendingAirdropId nextAirdropId = airdrop.nextAirdrop();
        if (prevAirdropId != null) {
            AccountPendingAirdrop prevAirdrop = pendingAirdropStore.get(prevAirdropId);
            if (prevAirdrop == null) {
                log.error("Failed to find pending airdrop with id {}", (Object)prevAirdropId);
            } else {
                updatedAirdrop = prevAirdrop.copyBuilder().nextAirdrop(nextAirdropId).build();
                pendingAirdropStore.put(prevAirdropId, updatedAirdrop);
            }
        }
        if (nextAirdropId != null) {
            AccountPendingAirdrop nextAirdrop = pendingAirdropStore.get(nextAirdropId);
            if (nextAirdrop == null) {
                log.error("Failed to find pending airdrop with id {}", (Object)nextAirdropId);
            } else {
                updatedAirdrop = nextAirdrop.copyBuilder().previousAirdrop(prevAirdropId).build();
                pendingAirdropStore.put(nextAirdropId, updatedAirdrop);
            }
        }
        if ((senderAccount = accountStore.getAccountById(airdropId.senderIdOrThrow())) == null) {
            log.error("Failed to find sender account with id {}", (Object)airdropId.senderIdOrThrow());
        } else {
            Account.Builder updatedSender = senderAccount.copyBuilder().numberPendingAirdrops(senderAccount.numberPendingAirdrops() - 1L);
            if (airdropId.equals((Object)senderAccount.headPendingAirdropId())) {
                updatedSender.headPendingAirdropId(airdrop.nextAirdrop());
            }
            accountStore.put(updatedSender.build());
        }
        pendingAirdropStore.remove(airdropId);
    }
}

