/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.service.registry.Scope;
import io.helidon.service.registry.Service;
import java.util.Optional;

@Service.Singleton
@Service.NamedByType(value=Service.PerRequest.class)
class PerRequestScopeHandler
implements Service.ScopeHandler {
    private static final ThreadLocal<ScopeInfo> REQUEST_SCOPES = new ThreadLocal();

    PerRequestScopeHandler() {
    }

    @Override
    public Optional<Scope> currentScope() {
        return Optional.ofNullable(REQUEST_SCOPES.get()).map(ScopeInfo::scope);
    }

    @Override
    public void activate(Scope scope) {
        ScopeInfo currentScope = REQUEST_SCOPES.get();
        if (currentScope != null) {
            throw new IllegalStateException("Attempt to re-create request scope. Already exists for this request: " + String.valueOf(currentScope.scope));
        }
        REQUEST_SCOPES.set(new ScopeInfo(scope, Thread.currentThread()));
        scope.registry().activate();
    }

    @Override
    public void deactivate(Scope scope) {
        ScopeInfo currentScope = REQUEST_SCOPES.get();
        if (currentScope == null) {
            throw new IllegalStateException("Current scope already de-activated: " + String.valueOf(scope));
        }
        if (currentScope.scope != scope) {
            throw new IllegalStateException("Memory leak! Attempting to close request scope in a different thread. Expected scope: " + String.valueOf(scope) + ", thread scope: " + String.valueOf(currentScope) + ", thread that started the scope: " + String.valueOf(currentScope.thread) + ", current thread: " + String.valueOf(Thread.currentThread()));
        }
        REQUEST_SCOPES.remove();
        scope.registry().deactivate();
    }

    private record ScopeInfo(Scope scope, Thread thread) {
    }
}

