/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.store;

import com.hedera.node.app.hints.ReadableHintsStore;
import com.hedera.node.app.hints.impl.ReadableHintsStoreImpl;
import com.hedera.node.app.history.ReadableHistoryStore;
import com.hedera.node.app.history.impl.ReadableHistoryStoreImpl;
import com.hedera.node.app.records.ReadableBlockRecordStore;
import com.hedera.node.app.service.addressbook.ReadableAccountNodeRelStore;
import com.hedera.node.app.service.addressbook.ReadableNodeStore;
import com.hedera.node.app.service.addressbook.impl.ReadableAccountNodeRelStoreImpl;
import com.hedera.node.app.service.addressbook.impl.ReadableNodeStoreImpl;
import com.hedera.node.app.service.consensus.ReadableTopicStore;
import com.hedera.node.app.service.consensus.impl.ReadableTopicStoreImpl;
import com.hedera.node.app.service.contract.ReadableEvmHookStore;
import com.hedera.node.app.service.contract.impl.state.ContractStateStore;
import com.hedera.node.app.service.contract.impl.state.ReadableContractStateStore;
import com.hedera.node.app.service.contract.impl.state.ReadableEvmHookStoreImpl;
import com.hedera.node.app.service.entityid.ReadableEntityCounters;
import com.hedera.node.app.service.entityid.ReadableEntityIdStore;
import com.hedera.node.app.service.entityid.impl.ReadableEntityIdStoreImpl;
import com.hedera.node.app.service.file.ReadableFileStore;
import com.hedera.node.app.service.file.ReadableUpgradeFileStore;
import com.hedera.node.app.service.file.impl.ReadableFileStoreImpl;
import com.hedera.node.app.service.file.impl.ReadableUpgradeFileStoreImpl;
import com.hedera.node.app.service.networkadmin.ReadableFreezeStore;
import com.hedera.node.app.service.networkadmin.impl.ReadableFreezeStoreImpl;
import com.hedera.node.app.service.schedule.ReadableScheduleStore;
import com.hedera.node.app.service.schedule.impl.ReadableScheduleStoreImpl;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableAirdropStore;
import com.hedera.node.app.service.token.ReadableNetworkStakingRewardsStore;
import com.hedera.node.app.service.token.ReadableNftStore;
import com.hedera.node.app.service.token.ReadableStakingInfoStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.ReadableAccountStoreImpl;
import com.hedera.node.app.service.token.impl.ReadableAirdropStoreImpl;
import com.hedera.node.app.service.token.impl.ReadableNetworkStakingRewardsStoreImpl;
import com.hedera.node.app.service.token.impl.ReadableNftStoreImpl;
import com.hedera.node.app.service.token.impl.ReadableStakingInfoStoreImpl;
import com.hedera.node.app.service.token.impl.ReadableTokenRelationStoreImpl;
import com.hedera.node.app.service.token.impl.ReadableTokenStoreImpl;
import com.swirlds.platform.state.service.ReadablePlatformStateStore;
import com.swirlds.state.State;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.hiero.consensus.roster.ReadableRosterStore;
import org.hiero.consensus.roster.ReadableRosterStoreImpl;

public class ReadableStoreFactory {
    private static final Map<Class<?>, StoreEntry> STORE_FACTORY = ReadableStoreFactory.createFactoryMap();
    private final State state;

    private static Map<Class<?>, StoreEntry> createFactoryMap() {
        HashMap<Class, StoreEntry> newMap = new HashMap<Class, StoreEntry>();
        newMap.put(ReadableAccountStore.class, new StoreEntry("TokenService", ReadableAccountStoreImpl::new));
        newMap.put(ReadableAirdropStore.class, new StoreEntry("TokenService", ReadableAirdropStoreImpl::new));
        newMap.put(ReadableNftStore.class, new StoreEntry("TokenService", ReadableNftStoreImpl::new));
        newMap.put(ReadableStakingInfoStore.class, new StoreEntry("TokenService", ReadableStakingInfoStoreImpl::new));
        newMap.put(ReadableTokenStore.class, new StoreEntry("TokenService", ReadableTokenStoreImpl::new));
        newMap.put(ReadableTokenRelationStore.class, new StoreEntry("TokenService", ReadableTokenRelationStoreImpl::new));
        newMap.put(ReadableNetworkStakingRewardsStore.class, new StoreEntry("TokenService", (states, entityCounters) -> new ReadableNetworkStakingRewardsStoreImpl(states)));
        newMap.put(ReadableTopicStore.class, new StoreEntry("ConsensusService", ReadableTopicStoreImpl::new));
        newMap.put(ReadableScheduleStore.class, new StoreEntry("ScheduleService", ReadableScheduleStoreImpl::new));
        newMap.put(ReadableFileStore.class, new StoreEntry("FileService", ReadableFileStoreImpl::new));
        newMap.put(ReadableUpgradeFileStore.class, new StoreEntry("FileService", (states, entityCounters) -> new ReadableUpgradeFileStoreImpl(states)));
        newMap.put(ReadableFreezeStore.class, new StoreEntry("FreezeService", (states, entityCounters) -> new ReadableFreezeStoreImpl(states)));
        newMap.put(ContractStateStore.class, new StoreEntry("ContractService", ReadableContractStateStore::new));
        newMap.put(ReadableEvmHookStore.class, new StoreEntry("ContractService", (states, entityCounters) -> new ReadableEvmHookStoreImpl(states)));
        newMap.put(ReadableBlockRecordStore.class, new StoreEntry("BlockRecordService", (states, entityCounters) -> new ReadableBlockRecordStore((ReadableStates)states)));
        newMap.put(ReadableNodeStore.class, new StoreEntry("AddressBookService", ReadableNodeStoreImpl::new));
        newMap.put(ReadableAccountNodeRelStore.class, new StoreEntry("AddressBookService", (states, entityCounters) -> new ReadableAccountNodeRelStoreImpl(states)));
        newMap.put(ReadablePlatformStateStore.class, new StoreEntry("PlatformStateService", (states, entityCounters) -> new ReadablePlatformStateStore(states)));
        newMap.put(ReadableRosterStore.class, new StoreEntry("RosterService", (states, entityCounters) -> new ReadableRosterStoreImpl(states)));
        newMap.put(ReadableEntityIdStore.class, new StoreEntry("EntityIdService", (states, entityCounters) -> new ReadableEntityIdStoreImpl(states)));
        newMap.put(ReadableHintsStore.class, new StoreEntry("HintsService", (states, entityCounters) -> new ReadableHintsStoreImpl((ReadableStates)states, (ReadableEntityCounters)entityCounters)));
        newMap.put(ReadableHistoryStore.class, new StoreEntry("HistoryService", (states, entityCounters) -> new ReadableHistoryStoreImpl((ReadableStates)states)));
        return Collections.unmodifiableMap(newMap);
    }

    public ReadableStoreFactory(@NonNull State state) {
        this.state = Objects.requireNonNull(state, "The supplied argument 'state' cannot be null!");
    }

    @NonNull
    public <C> C getStore(@NonNull Class<C> storeInterface) throws IllegalArgumentException {
        Objects.requireNonNull(storeInterface, "The supplied argument 'storeInterface' cannot be null!");
        StoreEntry entry = STORE_FACTORY.get(storeInterface);
        if (entry != null) {
            ReadableEntityIdStoreImpl readableEntityIdStore;
            ReadableStates readableStates = this.state.getReadableStates(entry.name);
            Object store = entry.createFrom(readableStates, (ReadableEntityCounters)(readableEntityIdStore = new ReadableEntityIdStoreImpl(this.state.getReadableStates("EntityIdService"))));
            if (!storeInterface.isInstance(store)) {
                throw new IllegalArgumentException("No instance " + String.valueOf(storeInterface) + " is available");
            }
            return storeInterface.cast(store);
        }
        throw new IllegalArgumentException("No store of class " + String.valueOf(storeInterface) + " is available");
    }

    private record StoreEntry(@NonNull String name, @Nullable BiFunction<ReadableStates, ReadableEntityCounters, ?> fromStates) {
        private StoreEntry {
            Objects.requireNonNull(name);
            Objects.requireNonNull(fromStates);
        }

        public <T> T createFrom(@NonNull ReadableStates readableStates, @NonNull ReadableEntityCounters entityCounters) {
            Objects.requireNonNull(readableStates);
            return (T)this.fromStates.apply(readableStates, entityCounters);
        }
    }
}

