/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto;

import com.google.common.base.Suppliers;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.function.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.crypto.MessageDigestFactory;

public abstract class Hash {
    private static final Supplier<MessageDigest> KECCAK256_SUPPLIER = Suppliers.memoize(() -> Hash.messageDigest("KECCAK-256"));
    private static final Supplier<MessageDigest> SHA256_SUPPLIER = Suppliers.memoize(() -> Hash.messageDigest("SHA-256"));
    private static final Supplier<MessageDigest> RIPEMD160_SUPPLIER = Suppliers.memoize(() -> Hash.messageDigest("RIPEMD160"));
    private static final Supplier<MessageDigest> BLAKE2BF_SUPPLIER = Suppliers.memoize(() -> Hash.messageDigest("BLAKE2BF"));

    private Hash() {
    }

    private static MessageDigest messageDigest(String algorithm) {
        try {
            return MessageDigestFactory.create(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] digestUsingAlgorithm(Bytes input, Supplier<MessageDigest> digestSupplier) {
        try {
            MessageDigest digest = (MessageDigest)digestSupplier.get().clone();
            input.update(digest);
            return digest.digest();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static Bytes32 sha256(Bytes input) {
        return Bytes32.wrap((byte[])Hash.digestUsingAlgorithm(input, SHA256_SUPPLIER));
    }

    public static Bytes32 keccak256(Bytes input) {
        return Bytes32.wrap((byte[])Hash.digestUsingAlgorithm(input, KECCAK256_SUPPLIER));
    }

    public static Bytes ripemd160(Bytes input) {
        return Bytes.wrap((byte[])Hash.digestUsingAlgorithm(input, RIPEMD160_SUPPLIER));
    }

    public static Bytes blake2bf(Bytes input) {
        return Bytes.wrap((byte[])Hash.digestUsingAlgorithm(input, BLAKE2BF_SUPPLIER));
    }
}

