/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.addressbook.impl.handlers;

import com.hedera.hapi.node.addressbook.NodeUpdateTransactionBody;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.ThresholdKey;
import com.hedera.hapi.node.state.addressbook.Node;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.addressbook.AddressBookHelper;
import com.hedera.node.app.service.addressbook.ReadableNodeStore;
import com.hedera.node.app.service.addressbook.impl.WritableAccountNodeRelStore;
import com.hedera.node.app.service.addressbook.impl.WritableNodeStore;
import com.hedera.node.app.service.addressbook.impl.validators.AddressBookValidator;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.spi.fees.FeeCalculator;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.NodesConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class NodeUpdateHandler
implements TransactionHandler {
    private final AddressBookValidator addressBookValidator;

    @Inject
    public NodeUpdateHandler(@NonNull AddressBookValidator addressBookValidator) {
        this.addressBookValidator = Objects.requireNonNull(addressBookValidator, "The supplied argument 'addressBookValidator' must not be null");
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        Objects.requireNonNull(txn);
        NodeUpdateTransactionBody op = txn.nodeUpdateOrThrow();
        PreCheckException.validateFalsePreCheck((op.nodeId() < 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NODE_ID);
        if (op.hasGossipCaCertificate()) {
            PreCheckException.validateFalsePreCheck((boolean)op.gossipCaCertificate().equals((Object)Bytes.EMPTY), (ResponseCodeEnum)ResponseCodeEnum.INVALID_GOSSIP_CA_CERTIFICATE);
            AddressBookValidator.validateX509Certificate(op.gossipCaCertificate());
        }
        if (op.hasAdminKey()) {
            Key adminKey = op.adminKey();
            this.addressBookValidator.validateAdminKey(adminKey);
        }
        if (op.hasGrpcCertificateHash()) {
            PreCheckException.validateFalsePreCheck((boolean)op.grpcCertificateHash().equals((Object)Bytes.EMPTY), (ResponseCodeEnum)ResponseCodeEnum.INVALID_GRPC_CERTIFICATE_HASH);
        }
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        NodeUpdateTransactionBody op = context.body().nodeUpdateOrThrow();
        ReadableNodeStore nodeStore = (ReadableNodeStore)context.createStore(ReadableNodeStore.class);
        NodesConfig config = (NodesConfig)context.configuration().getConfigData(NodesConfig.class);
        Node existingNode = nodeStore.get(op.nodeId());
        PreCheckException.validateFalsePreCheck((existingNode == null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NODE_ID);
        PreCheckException.validateFalsePreCheck((boolean)existingNode.deleted(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_NODE_ID);
        if (op.hasAccountId()) {
            PreCheckException.validateTruePreCheck((boolean)config.updateAccountIdAllowed(), (ResponseCodeEnum)ResponseCodeEnum.UPDATE_NODE_ACCOUNT_NOT_ALLOWED);
            AccountID newAccountId = op.accountIdOrThrow();
            this.addressBookValidator.validateAccountId(newAccountId);
            context.requireKeyOrThrow(newAccountId, ResponseCodeEnum.INVALID_SIGNATURE);
            if (this.onlyUpdatesAccountID(op)) {
                this.handleAccountIdOnlyUpdate(context, existingNode);
                return;
            }
        }
        context.requireKeyOrThrow(existingNode.adminKey(), ResponseCodeEnum.INVALID_ADMIN_KEY);
        if (op.hasAdminKey()) {
            context.requireKeyOrThrow(op.adminKeyOrThrow(), ResponseCodeEnum.INVALID_ADMIN_KEY);
        }
    }

    public void handle(@NonNull HandleContext handleContext) {
        Objects.requireNonNull(handleContext);
        NodeUpdateTransactionBody op = handleContext.body().nodeUpdateOrThrow();
        Configuration configuration = handleContext.configuration();
        NodesConfig nodeConfig = (NodesConfig)configuration.getConfigData(NodesConfig.class);
        StoreFactory storeFactory = handleContext.storeFactory();
        WritableNodeStore nodeStore = (WritableNodeStore)storeFactory.writableStore(WritableNodeStore.class);
        WritableAccountNodeRelStore accountNodeRelStore = (WritableAccountNodeRelStore)storeFactory.writableStore(WritableAccountNodeRelStore.class);
        ReadableAccountStore accountStore = (ReadableAccountStore)storeFactory.readableStore(ReadableAccountStore.class);
        Node existingNode = nodeStore.get(op.nodeId());
        HandleException.validateFalse((existingNode == null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NODE_ID);
        if (op.hasAccountId()) {
            AccountID accountId = op.accountIdOrThrow();
            HandleException.validateTrue((boolean)accountStore.contains(accountId), (ResponseCodeEnum)ResponseCodeEnum.INVALID_NODE_ACCOUNT_ID);
            if (!accountId.equals((Object)existingNode.accountId())) {
                Account account = this.addressBookValidator.validateAccount(accountId, accountStore, accountNodeRelStore, handleContext.expiryValidator());
                HandleException.validateTrue((account.tinybarBalance() > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.NODE_ACCOUNT_HAS_ZERO_BALANCE);
                accountNodeRelStore.remove(existingNode.accountId());
                accountNodeRelStore.put(accountId, existingNode.nodeId());
            }
        }
        if (op.hasDescription()) {
            this.addressBookValidator.validateDescription(op.description(), nodeConfig);
        }
        if (!op.gossipEndpoint().isEmpty()) {
            this.addressBookValidator.validateGossipEndpoint(op.gossipEndpoint(), nodeConfig);
        }
        if (!op.serviceEndpoint().isEmpty()) {
            this.addressBookValidator.validateServiceEndpoint(op.serviceEndpoint(), nodeConfig);
        }
        boolean proxyIsSentinelValue = false;
        if (op.hasGrpcProxyEndpoint()) {
            HandleException.validateTrue((boolean)nodeConfig.webProxyEndpointsEnabled(), (ResponseCodeEnum)ResponseCodeEnum.GRPC_WEB_PROXY_NOT_SUPPORTED);
            if (Objects.equals(op.grpcProxyEndpointOrThrow(), ServiceEndpoint.DEFAULT)) {
                proxyIsSentinelValue = true;
            } else {
                this.addressBookValidator.validateFqdnEndpoint(op.grpcProxyEndpoint(), nodeConfig);
            }
        }
        Node.Builder nodeBuilder = this.updateNode(op, existingNode, proxyIsSentinelValue);
        nodeStore.put(nodeBuilder.build());
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        AddressBookHelper.checkDABEnabled((FeeContext)feeContext);
        FeeCalculator calculator = feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT);
        calculator.resetUsage();
        calculator.addVerificationsPerTransaction((long)Math.max(0, feeContext.numTxnSignatures() - 1));
        return calculator.calculate();
    }

    private Node.Builder updateNode(@NonNull NodeUpdateTransactionBody op, @NonNull Node node, boolean unsetWebProxy) {
        Objects.requireNonNull(op);
        Objects.requireNonNull(node);
        Node.Builder nodeBuilder = node.copyBuilder();
        if (op.hasAccountId()) {
            nodeBuilder.accountId(op.accountId());
        }
        if (op.hasDescription()) {
            nodeBuilder.description(op.description());
        }
        if (!op.gossipEndpoint().isEmpty()) {
            nodeBuilder.gossipEndpoint(op.gossipEndpoint());
        }
        if (!op.serviceEndpoint().isEmpty()) {
            nodeBuilder.serviceEndpoint(op.serviceEndpoint());
        }
        if (op.hasGossipCaCertificate()) {
            nodeBuilder.gossipCaCertificate(op.gossipCaCertificate());
        }
        if (op.hasGrpcCertificateHash()) {
            nodeBuilder.grpcCertificateHash(op.grpcCertificateHash());
        }
        if (op.hasAdminKey()) {
            nodeBuilder.adminKey(op.adminKey());
        }
        if (op.hasDeclineReward()) {
            nodeBuilder.declineReward(op.declineReward().booleanValue());
        }
        if (op.hasGrpcProxyEndpoint()) {
            nodeBuilder.grpcProxyEndpoint(unsetWebProxy ? null : op.grpcProxyEndpoint());
        }
        return nodeBuilder;
    }

    private void handleAccountIdOnlyUpdate(PreHandleContext context, Node existingNode) throws PreCheckException {
        if (existingNode.hasAccountId()) {
            Key requiredKey = NodeUpdateHandler.oneOf(existingNode.adminKey(), context.getAccountKey(existingNode.accountIdOrThrow()));
            context.requireKeyOrThrow(requiredKey, ResponseCodeEnum.INVALID_SIGNATURE);
        } else {
            context.requireKeyOrThrow(existingNode.adminKey(), ResponseCodeEnum.INVALID_ADMIN_KEY);
        }
    }

    private boolean onlyUpdatesAccountID(@NonNull NodeUpdateTransactionBody op) {
        return op.hasAccountId() && !op.hasDescription() && !op.hasAdminKey() && op.gossipEndpoint().isEmpty() && op.serviceEndpoint().isEmpty() && !op.hasGossipCaCertificate() && !op.hasGrpcCertificateHash() && !op.hasDeclineReward() && !op.hasGrpcProxyEndpoint();
    }

    private static Key oneOf(Key ... acceptedKeys) {
        return Key.newBuilder().thresholdKey(ThresholdKey.newBuilder().keys(new KeyList(Arrays.asList(acceptedKeys))).threshold(1).build()).build();
    }
}

