/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.hbarallowance;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.HasCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.hbarallowance.HbarAllowanceCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class HbarAllowanceTranslator
extends AbstractCallTranslator<HasCallAttempt> {
    public static final SystemContractMethod HBAR_ALLOWANCE_PROXY = SystemContractMethod.declare("hbarAllowance(address)", "(int64,int256)").withVia(SystemContractMethod.CallVia.PROXY).withModifier(SystemContractMethod.Modifier.VIEW).withCategories(SystemContractMethod.Category.ALLOWANCE);
    public static final SystemContractMethod HBAR_ALLOWANCE = SystemContractMethod.declare("hbarAllowance(address,address)", "(int64,int256)").withModifier(SystemContractMethod.Modifier.VIEW).withCategories(SystemContractMethod.Category.ALLOWANCE);

    @Inject
    public HbarAllowanceTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HAS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(HBAR_ALLOWANCE, HBAR_ALLOWANCE_PROXY);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HasCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isMethod(HBAR_ALLOWANCE, HBAR_ALLOWANCE_PROXY);
    }

    @Override
    public Call callFrom(@NonNull HasCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        if (attempt.isSelector(HBAR_ALLOWANCE)) {
            return this.decodeAllowance(attempt);
        }
        if (attempt.isSelector(HBAR_ALLOWANCE_PROXY)) {
            return this.decodeAllowanceProxy(attempt);
        }
        return null;
    }

    @NonNull
    private Call decodeAllowance(@NonNull HasCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        Tuple call = HBAR_ALLOWANCE.decodeCall(attempt.inputBytes());
        AccountID owner = attempt.addressIdConverter().convert((Address)call.get(0));
        AccountID spender = attempt.addressIdConverter().convert((Address)call.get(1));
        return new HbarAllowanceCall(attempt, owner, spender);
    }

    @NonNull
    private Call decodeAllowanceProxy(@NonNull HasCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        Tuple call = HBAR_ALLOWANCE_PROXY.decodeCall(attempt.inputBytes());
        AccountID spender = attempt.addressIdConverter().convert((Address)call.get(0));
        return new HbarAllowanceCall(attempt, attempt.redirectAccountId(), spender);
    }
}

