/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.hiero.base.crypto.SignatureType;

public final class SignatureGenerator {
    public static final Provider BOUNCYCASTLE_PROVIDER = new BouncyCastleProvider();

    private SignatureGenerator() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static byte[] signBytes(byte[] msg, PrivateKey privateKey) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        if (privateKey instanceof EdDSAPrivateKey) {
            EdDSAEngine engine = new EdDSAEngine();
            engine.initSign(privateKey);
            return engine.signOneShot(msg);
        }
        if (privateKey instanceof ECPrivateKey) {
            Signature ecdsaSign = Signature.getInstance(SignatureType.ECDSA_SECP256K1.signingAlgorithm(), BOUNCYCASTLE_PROVIDER);
            ecdsaSign.initSign(privateKey);
            ecdsaSign.update(msg);
            byte[] asn1Sig = ecdsaSign.sign();
            return SignatureGenerator.rawEcdsaSigFromAsn1Der(asn1Sig);
        }
        throw new IllegalArgumentException("Unusable private key " + String.valueOf(privateKey));
    }

    private static byte[] rawEcdsaSigFromAsn1Der(byte[] derSig) {
        int origSLen;
        int finalSLen;
        int origRLen;
        int finalRLen;
        int rLenIndex = 3;
        byte[] rawBytes = new byte[64];
        int rStart = 4;
        for (finalRLen = origRLen = derSig[3] & 0xFF; finalRLen > 32; --finalRLen) {
            ++rStart;
        }
        System.arraycopy(derSig, rStart, rawBytes, 32 - finalRLen, Math.min(32, origRLen));
        int sLenPos = 3 + (derSig[3] & 0xFF) + 2;
        int sStart = sLenPos + 1;
        for (finalSLen = origSLen = derSig[sLenPos] & 0xFF; finalSLen > 32; --finalSLen) {
            ++sStart;
        }
        System.arraycopy(derSig, sStart, rawBytes, 32 + (32 - finalSLen), Math.min(32, origSLen));
        return rawBytes;
    }
}

