/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.file.impl.schemas;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hedera.hapi.node.base.CurrentAndNextFeeSchedule;
import com.hedera.hapi.node.base.FeeComponents;
import com.hedera.hapi.node.base.FeeData;
import com.hedera.hapi.node.base.FeeSchedule;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.NodeAddress;
import com.hedera.hapi.node.base.NodeAddressBook;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.ServicesConfigurationList;
import com.hedera.hapi.node.base.Setting;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TimestampSeconds;
import com.hedera.hapi.node.base.TransactionFeeSchedule;
import com.hedera.hapi.node.file.FileCreateTransactionBody;
import com.hedera.hapi.node.file.FileUpdateTransactionBody;
import com.hedera.hapi.node.state.addressbook.Node;
import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.hapi.node.state.file.File;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.hapi.node.transaction.ExchangeRateSet;
import com.hedera.hapi.platform.state.SingletonType;
import com.hedera.hapi.platform.state.StateKey;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.hapi.utils.sysfiles.domain.throttling.ThrottleDefinitions;
import com.hedera.node.app.service.addressbook.ReadableNodeStore;
import com.hedera.node.app.spi.workflows.SystemContext;
import com.hedera.node.config.data.BootstrapConfig;
import com.hedera.node.config.data.EntitiesConfig;
import com.hedera.node.config.data.FilesConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.types.LongPair;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.utility.CommonUtils;
import org.hiero.hapi.support.fees.FeeSchedule;

@Singleton
public class V0490FileSchema
extends Schema<SemanticVersion> {
    private static final Logger logger = LogManager.getLogger(V0490FileSchema.class);
    public static final String FILES_KEY = "FILES";
    public static final int FILES_STATE_ID = StateKey.KeyOneOfType.FILESERVICE_I_FILES.protoOrdinal();
    public static final String FILES_STATE_LABEL = StateMetadata.computeLabel((String)"FileService", (String)"FILES");
    public static final String UPGRADE_DATA_STATE_KEY_PATTERN = "FileService_I_UPGRADE_DATA_%d";
    private static final String DEFAULT_THROTTLES_RESOURCE = "genesis/throttles.json";
    private static final int MAX_FILES_HINT = 50000;
    private static final SemanticVersion VERSION = SemanticVersion.newBuilder().major(0).minor(49).patch(0).build();

    @Inject
    public V0490FileSchema() {
        super((Object)VERSION, HapiUtils.SEMANTIC_VERSION_COMPARATOR);
    }

    @NonNull
    public Set<StateDefinition> statesToCreate(@NonNull Configuration config) {
        LinkedHashSet<StateDefinition> definitions = new LinkedHashSet<StateDefinition>();
        definitions.add(StateDefinition.onDisk((int)FILES_STATE_ID, (String)FILES_KEY, (Codec)FileID.PROTOBUF, (Codec)File.PROTOBUF, (long)50000L));
        FilesConfig filesConfig = (FilesConfig)config.getConfigData(FilesConfig.class);
        LongPair fileNums = filesConfig.softwareUpdateRange();
        long firstUpdateNum = fileNums.left();
        long lastUpdateNum = fileNums.right();
        for (long updateNum = firstUpdateNum; updateNum <= lastUpdateNum; ++updateNum) {
            String stateKey = UPGRADE_DATA_STATE_KEY_PATTERN.formatted(updateNum).toUpperCase();
            int stateId = SingletonType.valueOf((String)stateKey).protoOrdinal();
            definitions.add(StateDefinition.queue((int)stateId, (String)stateKey, (Codec)ProtoBytes.PROTOBUF));
        }
        return definitions;
    }

    public void migrate(@NonNull MigrationContext ctx) {
    }

    public void createGenesisAddressBookAndNodeDetails(@NonNull SystemContext systemContext, @NonNull ReadableNodeStore nodeStore) {
        Objects.requireNonNull(systemContext);
        FilesConfig filesConfig = (FilesConfig)systemContext.configuration().getConfigData(FilesConfig.class);
        BootstrapConfig bootstrapConfig = (BootstrapConfig)systemContext.configuration().getConfigData(BootstrapConfig.class);
        KeyList masterKey = KeyList.newBuilder().keys(new Key[]{Key.newBuilder().ed25519(bootstrapConfig.genesisPublicKey()).build()}).build();
        long addressBookFileNum = filesConfig.addressBook();
        systemContext.dispatchCreation(b -> b.fileCreate(FileCreateTransactionBody.newBuilder().contents(this.nodeStoreAddressBook(nodeStore)).keys(masterKey).expirationTime(V0490FileSchema.maxLifetimeExpiry(systemContext)).build()).build(), addressBookFileNum);
        long nodeInfoFileNum = filesConfig.nodeDetails();
        systemContext.dispatchCreation(b -> b.fileCreate(FileCreateTransactionBody.newBuilder().contents(this.nodeStoreNodeDetails(nodeStore)).keys(masterKey).expirationTime(V0490FileSchema.maxLifetimeExpiry(systemContext)).build()).build(), nodeInfoFileNum);
    }

    public void updateAddressBookAndNodeDetailsAfterFreeze(@NonNull SystemContext systemContext, @NonNull ReadableNodeStore nodeStore) {
        Objects.requireNonNull(systemContext);
        Configuration config = systemContext.configuration();
        FilesConfig filesConfig = (FilesConfig)config.getConfigData(FilesConfig.class);
        V0490FileSchema.dispatchSynthFileUpdate(systemContext, V0490FileSchema.createFileID(filesConfig.nodeDetails(), config), this.nodeStoreNodeDetails(nodeStore));
        V0490FileSchema.dispatchSynthFileUpdate(systemContext, V0490FileSchema.createFileID(filesConfig.addressBook(), config), this.nodeStoreAddressBook(nodeStore));
    }

    public static void dispatchSynthFileUpdate(@NonNull SystemContext systemContext, @NonNull FileID fileId, @NonNull Bytes contents) {
        systemContext.dispatchAdmin(b -> b.fileUpdate(FileUpdateTransactionBody.newBuilder().fileID(fileId).contents(contents).expirationTime(V0490FileSchema.maxLifetimeExpiry(systemContext)).build()));
    }

    public Bytes nodeStoreNodeDetails(@NonNull ReadableNodeStore nodeStore) {
        ArrayList nodeDetails = new ArrayList();
        nodeStore.keys().stream().mapToLong(EntityNumber::number).mapToObj(arg_0 -> ((ReadableNodeStore)nodeStore).get(arg_0)).filter(node -> node != null && !node.deleted()).sorted(Comparator.comparingLong(Node::nodeId)).forEach(node -> nodeDetails.add(NodeAddress.newBuilder().nodeId(node.nodeId()).nodeAccountId(node.accountId()).nodeCertHash(this.getHexStringBytesFromBytes(node.grpcCertificateHash())).description(node.description()).stake(node.weight()).rsaPubKey(this.readableKey(this.getPublicKeyFromCertBytes(node.gossipCaCertificate().toByteArray(), node.nodeId()))).serviceEndpoint(node.serviceEndpoint()).build()));
        return NodeAddressBook.PROTOBUF.toBytes((Object)NodeAddressBook.newBuilder().nodeAddress(nodeDetails).build());
    }

    private Bytes getHexStringBytesFromBytes(Bytes rawBytes) {
        String hexString = HexFormat.of().formatHex(rawBytes.toByteArray());
        return Bytes.wrap((byte[])Normalizer.normalize(hexString, Normalizer.Form.NFD).getBytes(StandardCharsets.UTF_8));
    }

    public Bytes nodeStoreAddressBook(@NonNull ReadableNodeStore nodeStore) {
        ArrayList nodeAddresses = new ArrayList();
        nodeStore.keys().stream().mapToLong(EntityNumber::number).mapToObj(arg_0 -> ((ReadableNodeStore)nodeStore).get(arg_0)).filter(node -> node != null && !node.deleted()).sorted(Comparator.comparingLong(Node::nodeId)).forEach(node -> nodeAddresses.add(NodeAddress.newBuilder().nodeId(node.nodeId()).nodeCertHash(this.getHexStringBytesFromBytes(node.grpcCertificateHash())).nodeAccountId(node.accountId()).serviceEndpoint(node.serviceEndpoint()).build()));
        return NodeAddressBook.PROTOBUF.toBytes((Object)NodeAddressBook.newBuilder().nodeAddress(nodeAddresses).build());
    }

    public void createGenesisFeeSchedule(@NonNull SystemContext systemContext) {
        Objects.requireNonNull(systemContext);
        Configuration config = systemContext.configuration();
        BootstrapConfig bootstrapConfig = (BootstrapConfig)config.getConfigData(BootstrapConfig.class);
        Key masterKey = Key.newBuilder().ed25519(bootstrapConfig.genesisPublicKey()).build();
        systemContext.dispatchCreation(b -> b.fileCreate(FileCreateTransactionBody.newBuilder().contents(this.genesisFeeSchedules(config)).keys(KeyList.newBuilder().keys(new Key[]{masterKey})).expirationTime(V0490FileSchema.maxLifetimeExpiry(systemContext)).build()).build(), ((FilesConfig)config.getConfigData(FilesConfig.class)).feeSchedules());
    }

    public void createGenesisSimpleFeesSchedule(@NonNull SystemContext systemContext) {
        Objects.requireNonNull(systemContext);
        Configuration config = systemContext.configuration();
        BootstrapConfig bootstrapConfig = (BootstrapConfig)config.getConfigData(BootstrapConfig.class);
        Key masterKey = Key.newBuilder().ed25519(bootstrapConfig.genesisPublicKey()).build();
        systemContext.dispatchCreation(b -> b.fileCreate(FileCreateTransactionBody.newBuilder().contents(this.genesisSimpleFeesSchedules(config)).keys(KeyList.newBuilder().keys(new Key[]{masterKey})).expirationTime(V0490FileSchema.maxLifetimeExpiry(systemContext)).build()).build(), ((FilesConfig)config.getConfigData(FilesConfig.class)).simpleFeesSchedules());
    }

    public Bytes genesisFeeSchedules(@NonNull Configuration config) {
        Bytes bytes;
        block8: {
            String resourceName = ((BootstrapConfig)config.getConfigData(BootstrapConfig.class)).feeSchedulesJsonResource();
            InputStream in = V0490FileSchema.loadResourceInPackage(resourceName);
            try {
                byte[] feeScheduleJsonBytes = Objects.requireNonNull(in).readAllBytes();
                CurrentAndNextFeeSchedule feeSchedule = V0490FileSchema.parseFeeSchedules(feeScheduleJsonBytes);
                bytes = CurrentAndNextFeeSchedule.PROTOBUF.toBytes((Object)feeSchedule);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NullPointerException e) {
                    throw new IllegalArgumentException("Fee schedule (" + resourceName + ") could not be found in the class path", e);
                }
            }
            in.close();
        }
        return bytes;
    }

    public Bytes genesisSimpleFeesSchedules(@NonNull Configuration config) {
        Bytes bytes;
        block8: {
            String resourceName = ((BootstrapConfig)config.getConfigData(BootstrapConfig.class)).simpleFeesSchedulesJsonResource();
            InputStream in = V0490FileSchema.loadResourceInPackage(resourceName);
            try {
                byte[] feeScheduleJsonBytes = Objects.requireNonNull(in).readAllBytes();
                FeeSchedule feeSchedule = V0490FileSchema.parseSimpleFeesSchedules(feeScheduleJsonBytes);
                bytes = FeeSchedule.PROTOBUF.toBytes((Object)feeSchedule);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NullPointerException e) {
                    throw new IllegalArgumentException("Fee schedule (" + resourceName + ") could not be found in the class path", e);
                }
            }
            in.close();
        }
        return bytes;
    }

    public static CurrentAndNextFeeSchedule parseFeeSchedules(@NonNull byte[] feeScheduleJsonBytes) {
        try {
            ObjectMapper json = new ObjectMapper();
            JsonNode rootNode = json.readTree(feeScheduleJsonBytes);
            CurrentAndNextFeeSchedule.Builder builder = CurrentAndNextFeeSchedule.newBuilder();
            Iterator schedules = rootNode.elements();
            while (schedules.hasNext()) {
                JsonNode scheduleContainerNode = (JsonNode)schedules.next();
                if (scheduleContainerNode.has("currentFeeSchedule")) {
                    com.hedera.hapi.node.base.FeeSchedule currentFeeSchedule = V0490FileSchema.parseFeeSchedule(scheduleContainerNode.get("currentFeeSchedule"));
                    builder.currentFeeSchedule(currentFeeSchedule);
                    continue;
                }
                if (scheduleContainerNode.has("nextFeeSchedule")) {
                    com.hedera.hapi.node.base.FeeSchedule nextFeeSchedule = V0490FileSchema.parseFeeSchedule(scheduleContainerNode.get("nextFeeSchedule"));
                    builder.nextFeeSchedule(nextFeeSchedule);
                    continue;
                }
                logger.warn("Unexpected node encountered while parsing fee schedule: {}", (Object)scheduleContainerNode);
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse fee schedule file", e);
        }
    }

    private static com.hedera.hapi.node.base.FeeSchedule parseFeeSchedule(@NonNull JsonNode scheduleNode) {
        FeeSchedule.Builder builder = com.hedera.hapi.node.base.FeeSchedule.newBuilder();
        ArrayList<TransactionFeeSchedule> transactionFeeSchedules = new ArrayList<TransactionFeeSchedule>();
        Iterator transactionFeeScheduleIterator = scheduleNode.elements();
        while (transactionFeeScheduleIterator.hasNext()) {
            JsonNode childNode = (JsonNode)transactionFeeScheduleIterator.next();
            if (childNode.has("transactionFeeSchedule")) {
                JsonNode transactionFeeScheduleNode = childNode.get("transactionFeeSchedule");
                JsonNode feesContainer = transactionFeeScheduleNode.get("fees");
                ArrayList feeDataList = new ArrayList();
                feesContainer.elements().forEachRemaining(feeNode -> feeDataList.add(V0490FileSchema.parseFeeData(feeNode)));
                transactionFeeSchedules.add(TransactionFeeSchedule.newBuilder().hederaFunctionality(HederaFunctionality.fromString((String)transactionFeeScheduleNode.get("hederaFunctionality").asText())).fees(feeDataList).build());
                continue;
            }
            if (childNode.has("expiryTime")) {
                long expiryTime = childNode.get("expiryTime").asLong();
                builder.expiryTime(TimestampSeconds.newBuilder().seconds(expiryTime));
                continue;
            }
            logger.warn("Unexpected node encountered while parsing fee schedule: {}", (Object)childNode);
        }
        return builder.transactionFeeSchedule(transactionFeeSchedules).build();
    }

    private static FeeData parseFeeData(@NonNull JsonNode feeNode) {
        return FeeData.newBuilder().subType(Optional.ofNullable(feeNode.get("subType")).map(JsonNode::asText).map(SubType::fromString).orElse(SubType.DEFAULT)).nodedata(V0490FileSchema.parseFeeComponents(feeNode.get("nodedata"))).networkdata(V0490FileSchema.parseFeeComponents(feeNode.get("networkdata"))).servicedata(V0490FileSchema.parseFeeComponents(feeNode.get("servicedata"))).build();
    }

    private static FeeComponents parseFeeComponents(@NonNull JsonNode componentNode) {
        FeeComponents.Builder feeComponents = FeeComponents.newBuilder().constant(componentNode.get("constant").asLong()).bpt(componentNode.get("bpt").asLong()).vpt(componentNode.get("vpt").asLong()).rbh(componentNode.get("rbh").asLong()).sbh(componentNode.get("sbh").asLong()).gas(componentNode.get("gas").asLong()).bpr(componentNode.get("bpr").asLong()).sbpr(componentNode.get("sbpr").asLong()).min(componentNode.get("min").asLong()).max(componentNode.get("max").asLong());
        if (componentNode.get("tv") != null) {
            feeComponents.tv(componentNode.get("tv").asLong());
        }
        return feeComponents.build();
    }

    public static FeeSchedule parseSimpleFeesSchedules(@NonNull byte[] feeScheduleJsonBytes) {
        try {
            FeeSchedule feeSchedule = (FeeSchedule)FeeSchedule.JSON.parse(Bytes.wrap((byte[])feeScheduleJsonBytes));
            return feeSchedule;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse simple fee schedule file", e);
        }
    }

    public void createGenesisExchangeRate(@NonNull SystemContext systemContext) {
        Configuration config = systemContext.configuration();
        Key masterKey = Key.newBuilder().ed25519(((BootstrapConfig)config.getConfigData(BootstrapConfig.class)).genesisPublicKey()).build();
        systemContext.dispatchCreation(b -> b.fileCreate(FileCreateTransactionBody.newBuilder().contents(this.genesisExchangeRates(config)).keys(KeyList.newBuilder().keys(new Key[]{masterKey})).expirationTime(V0490FileSchema.maxLifetimeExpiry(systemContext)).build()).build(), ((FilesConfig)systemContext.configuration().getConfigData(FilesConfig.class)).exchangeRates());
    }

    public Bytes genesisExchangeRates(@NonNull Configuration config) {
        BootstrapConfig bootstrapConfig = (BootstrapConfig)config.getConfigData(BootstrapConfig.class);
        ExchangeRateSet exchangeRateSet = ExchangeRateSet.newBuilder().currentRate(ExchangeRate.newBuilder().centEquiv(bootstrapConfig.ratesCurrentCentEquiv()).hbarEquiv(bootstrapConfig.ratesCurrentHbarEquiv()).expirationTime(TimestampSeconds.newBuilder().seconds(bootstrapConfig.ratesCurrentExpiry())).build()).nextRate(ExchangeRate.newBuilder().centEquiv(bootstrapConfig.ratesNextCentEquiv()).hbarEquiv(bootstrapConfig.ratesNextHbarEquiv()).expirationTime(TimestampSeconds.newBuilder().seconds(bootstrapConfig.ratesNextExpiry())).build()).build();
        return ExchangeRateSet.PROTOBUF.toBytes((Object)exchangeRateSet);
    }

    public void createGenesisNetworkProperties(@NonNull SystemContext systemContext) {
        Configuration config = systemContext.configuration();
        BootstrapConfig bootstrapConfig = (BootstrapConfig)config.getConfigData(BootstrapConfig.class);
        Key masterKey = Key.newBuilder().ed25519(bootstrapConfig.genesisPublicKey()).build();
        systemContext.dispatchCreation(b -> b.fileCreate(FileCreateTransactionBody.newBuilder().contents(this.genesisNetworkProperties(config)).keys(KeyList.newBuilder().keys(new Key[]{masterKey})).expirationTime(V0490FileSchema.maxLifetimeExpiry(systemContext)).build()).build(), ((FilesConfig)systemContext.configuration().getConfigData(FilesConfig.class)).networkProperties());
    }

    public Bytes genesisNetworkProperties(@NonNull Configuration config) {
        ServicesConfigurationList servicesConfigList = ServicesConfigurationList.newBuilder().nameValue(List.of()).build();
        return ServicesConfigurationList.PROTOBUF.toBytes((Object)servicesConfigList);
    }

    public void createGenesisHapiPermissions(@NonNull SystemContext systemContext) {
        Configuration config = systemContext.configuration();
        BootstrapConfig bootstrapConfig = (BootstrapConfig)config.getConfigData(BootstrapConfig.class);
        Key masterKey = Key.newBuilder().ed25519(bootstrapConfig.genesisPublicKey()).build();
        systemContext.dispatchCreation(b -> b.fileCreate(FileCreateTransactionBody.newBuilder().contents(this.genesisHapiPermissions(config)).keys(KeyList.newBuilder().keys(new Key[]{masterKey})).expirationTime(V0490FileSchema.maxLifetimeExpiry(systemContext)).build()).build(), ((FilesConfig)systemContext.configuration().getConfigData(FilesConfig.class)).hapiPermissions());
    }

    public Bytes genesisHapiPermissions(@NonNull Configuration config) {
        BootstrapConfig bootstrapConfig = (BootstrapConfig)config.getConfigData(BootstrapConfig.class);
        Path pathToApiPermissions = Path.of(bootstrapConfig.hapiPermissionsPath(), new String[0]);
        String apiPermissionsContent = null;
        if (Files.exists(pathToApiPermissions, new LinkOption[0])) {
            try {
                apiPermissionsContent = Files.readString(pathToApiPermissions);
                logger.info("API Permissions loaded from {}", (Object)pathToApiPermissions);
            }
            catch (IOException e) {
                logger.warn("API Permissions could not be loaded from {}, looking for fallback on classpath", (Object)pathToApiPermissions);
            }
        }
        if (apiPermissionsContent == null) {
            String resourceName = "api-permission.properties";
            try (InputStream in = V0490FileSchema.loadResourceInRoot("api-permission.properties");){
                apiPermissionsContent = new String(Objects.requireNonNull(in).readAllBytes(), StandardCharsets.UTF_8);
                logger.info("API Permissions loaded from classpath resource {}", (Object)"api-permission.properties");
            }
            catch (IOException | NullPointerException e) {
                logger.fatal("API Permissions could not be loaded from classpath");
                throw new IllegalArgumentException("API Permissions could not be loaded from classpath", e);
            }
        }
        return V0490FileSchema.parseConfigList("HAPI permissions", apiPermissionsContent);
    }

    public static Bytes parseConfigList(@NonNull String purpose, @NonNull String content) {
        ArrayList settings = new ArrayList();
        try (StringReader in = new StringReader(content);){
            Properties props = new Properties();
            props.load(in);
            props.entrySet().stream().sorted(Comparator.comparing(entry -> String.valueOf(entry.getKey()))).forEach(entry -> settings.add(Setting.newBuilder().name(String.valueOf(entry.getKey())).value(String.valueOf(entry.getValue())).build()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(purpose + " config could not be parsed", e);
        }
        return ServicesConfigurationList.PROTOBUF.toBytes((Object)ServicesConfigurationList.newBuilder().nameValue(settings).build());
    }

    public void createGenesisThrottleDefinitions(@NonNull SystemContext systemContext) {
        Configuration config = systemContext.configuration();
        BootstrapConfig bootstrapConfig = (BootstrapConfig)config.getConfigData(BootstrapConfig.class);
        Key masterKey = Key.newBuilder().ed25519(bootstrapConfig.genesisPublicKey()).build();
        systemContext.dispatchCreation(b -> b.fileCreate(FileCreateTransactionBody.newBuilder().contents(this.genesisThrottleDefinitions(config)).keys(KeyList.newBuilder().keys(new Key[]{masterKey})).expirationTime(V0490FileSchema.maxLifetimeExpiry(systemContext)).build()).build(), ((FilesConfig)systemContext.configuration().getConfigData(FilesConfig.class)).throttleDefinitions());
    }

    public Bytes genesisThrottleDefinitions(@NonNull Configuration config) {
        BootstrapConfig bootstrapConfig = (BootstrapConfig)config.getConfigData(BootstrapConfig.class);
        byte[] throttleDefinitionsProtoBytes = V0490FileSchema.loadBootstrapThrottleDefinitions(bootstrapConfig);
        return Bytes.wrap((byte[])throttleDefinitionsProtoBytes);
    }

    private static byte[] loadBootstrapThrottleDefinitions(@NonNull BootstrapConfig bootstrapConfig) {
        InputStream in;
        String throttleDefinitionsResource = bootstrapConfig.throttleDefsJsonResource();
        String throttleDefinitionsFile = bootstrapConfig.throttleDefsJsonFile();
        Path pathToThrottleDefinitions = Path.of(throttleDefinitionsFile, new String[0]);
        String throttleDefinitionsContent = null;
        if (Files.exists(pathToThrottleDefinitions, new LinkOption[0])) {
            try {
                throttleDefinitionsContent = Files.readString(pathToThrottleDefinitions);
                logger.info("Throttle definitions loaded from {}", (Object)pathToThrottleDefinitions);
            }
            catch (IOException e) {
                logger.warn("Throttle definitions could not be loaded from {}, looking for fallback on classpath", (Object)pathToThrottleDefinitions);
            }
        }
        if (throttleDefinitionsContent == null) {
            try {
                in = V0490FileSchema.loadResourceInPackage(throttleDefinitionsResource);
                try {
                    throttleDefinitionsContent = new String(Objects.requireNonNull(in).readAllBytes(), StandardCharsets.UTF_8);
                    logger.info("Throttle definitions loaded from classpath resource {}", (Object)throttleDefinitionsResource);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (IOException | NullPointerException e) {
                logger.warn("Throttle definitions could not be loaded from classpath resource {}, using default fallback resource", (Object)throttleDefinitionsResource);
            }
        }
        if (throttleDefinitionsContent == null) {
            try {
                in = V0490FileSchema.loadResourceInPackage(DEFAULT_THROTTLES_RESOURCE);
                try {
                    throttleDefinitionsContent = new String(Objects.requireNonNull(in).readAllBytes(), StandardCharsets.UTF_8);
                    logger.info("Throttle definitions loaded from default fallback classpath resource {}", (Object)DEFAULT_THROTTLES_RESOURCE);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (IOException | NullPointerException e) {
                logger.fatal("Throttle definitions could not be loaded from default fallback classpath resource {}", (Object)DEFAULT_THROTTLES_RESOURCE);
                throw new IllegalArgumentException("Throttle definitions could not be loaded from default fallback classpath resource", e);
            }
        }
        return V0490FileSchema.parseThrottleDefinitions(throttleDefinitionsContent);
    }

    public static byte[] parseThrottleDefinitions(@NonNull String throttleJson) {
        try {
            ObjectMapper om = new ObjectMapper();
            ThrottleDefinitions throttleDefinitionsObj = (ThrottleDefinitions)om.readValue(throttleJson, ThrottleDefinitions.class);
            return throttleDefinitionsObj.toProto().toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse throttle definitions", e);
        }
    }

    public void createGenesisSoftwareUpdateFiles(@NonNull SystemContext systemContext) {
        BootstrapConfig bootstrapConfig = (BootstrapConfig)systemContext.configuration().getConfigData(BootstrapConfig.class);
        LongPair updateFilesRange = ((FilesConfig)systemContext.configuration().getConfigData(FilesConfig.class)).softwareUpdateRange();
        Key masterKey = Key.newBuilder().ed25519(bootstrapConfig.genesisPublicKey()).build();
        Long updateNum = updateFilesRange.left();
        while (updateNum <= updateFilesRange.right()) {
            systemContext.dispatchCreation(b -> b.fileCreate(FileCreateTransactionBody.newBuilder().contents(Bytes.EMPTY).keys(KeyList.newBuilder().keys(new Key[]{masterKey})).expirationTime(V0490FileSchema.maxLifetimeExpiry(systemContext)).build()).build(), updateNum.longValue());
            Long l = updateNum;
            updateNum = updateNum + 1L;
        }
    }

    private static Timestamp maxLifetimeExpiry(@NonNull SystemContext systemContext) {
        return Timestamp.newBuilder().seconds(systemContext.now().getEpochSecond() + ((EntitiesConfig)systemContext.configuration().getConfigData(EntitiesConfig.class)).maxLifetime()).build();
    }

    private PublicKey getPublicKeyFromCertBytes(@NonNull byte[] certBytes, long nodeId) {
        try {
            X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certBytes));
            return certificate.getPublicKey();
        }
        catch (CertificateException e) {
            logger.error("Unable to extract RSA key for node{} from certificate bytes {}", (Object)nodeId, (Object)CommonUtils.hex((byte[])certBytes), (Object)e);
            return null;
        }
    }

    private String readableKey(@Nullable PublicKey publicKey) {
        if (publicKey == null) {
            return "";
        }
        return CommonUtils.hex((byte[])publicKey.getEncoded());
    }

    private static FileID createFileID(long fileNum, @NonNull Configuration config) {
        HederaConfig hederaConfig = (HederaConfig)config.getConfigData(HederaConfig.class);
        return FileID.newBuilder().realmNum(hederaConfig.realm()).shardNum(hederaConfig.shard()).fileNum(fileNum).build();
    }

    private static InputStream loadResourceInPackage(String resourcePath) {
        return V0490FileSchema.class.getResourceAsStream("/" + resourcePath);
    }

    private static InputStream loadResourceInRoot(String resourceName) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
    }
}

