/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.pricing;

import com.google.protobuf.ByteString;
import com.google.protobuf.Int32Value;
import com.google.protobuf.StringValue;
import com.hedera.node.app.hapi.fees.usage.BaseTransactionMeta;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.consensus.ConsensusOpsUsage;
import com.hedera.node.app.hapi.fees.usage.consensus.SubmitMessageMeta;
import com.hedera.node.app.hapi.fees.usage.contract.ExtantContractContext;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoApproveAllowanceMeta;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoCreateMeta;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoDeleteAllowanceMeta;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoOpsUsage;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoTransferMeta;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoUpdateMeta;
import com.hedera.node.app.hapi.fees.usage.crypto.ExtantCryptoContext;
import com.hedera.node.app.hapi.fees.usage.file.FileAppendMeta;
import com.hedera.node.app.hapi.fees.usage.file.FileOpsUsage;
import com.hedera.node.app.hapi.fees.usage.schedule.ScheduleOpsUsage;
import com.hedera.node.app.hapi.fees.usage.state.UsageAccumulator;
import com.hedera.node.app.hapi.fees.usage.token.TokenOpsUsage;
import com.hedera.node.app.hapi.fees.usage.token.TokenOpsUsageUtils;
import com.hedera.node.app.hapi.fees.usage.token.meta.ExtantFeeScheduleContext;
import com.hedera.node.app.hapi.fees.usage.token.meta.FeeScheduleUpdateMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenBurnMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenCreateMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenFreezeMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenMintMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenPauseMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenUnfreezeMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenUnpauseMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenWipeMeta;
import com.hedera.node.app.hapi.fees.usage.util.UtilOpsUsage;
import com.hedera.node.app.hapi.fees.usage.util.UtilPrngMeta;
import com.hederahashgraph.api.proto.java.AccountAmount;
import com.hederahashgraph.api.proto.java.AccountID;
import com.hederahashgraph.api.proto.java.ContractCallTransactionBody;
import com.hederahashgraph.api.proto.java.ContractID;
import com.hederahashgraph.api.proto.java.CryptoAllowance;
import com.hederahashgraph.api.proto.java.CryptoApproveAllowanceTransactionBody;
import com.hederahashgraph.api.proto.java.CryptoCreateTransactionBody;
import com.hederahashgraph.api.proto.java.CryptoDeleteAllowanceTransactionBody;
import com.hederahashgraph.api.proto.java.CryptoTransferTransactionBody;
import com.hederahashgraph.api.proto.java.CryptoUpdateTransactionBody;
import com.hederahashgraph.api.proto.java.CustomFee;
import com.hederahashgraph.api.proto.java.Duration;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.FixedFee;
import com.hederahashgraph.api.proto.java.HederaFunctionality;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.NftRemoveAllowance;
import com.hederahashgraph.api.proto.java.SchedulableTransactionBody;
import com.hederahashgraph.api.proto.java.ScheduleCreateTransactionBody;
import com.hederahashgraph.api.proto.java.SignatureMap;
import com.hederahashgraph.api.proto.java.SignaturePair;
import com.hederahashgraph.api.proto.java.SubType;
import com.hederahashgraph.api.proto.java.Timestamp;
import com.hederahashgraph.api.proto.java.TokenBurnTransactionBody;
import com.hederahashgraph.api.proto.java.TokenCreateTransactionBody;
import com.hederahashgraph.api.proto.java.TokenID;
import com.hederahashgraph.api.proto.java.TokenMintTransactionBody;
import com.hederahashgraph.api.proto.java.TokenType;
import com.hederahashgraph.api.proto.java.TokenWipeAccountTransactionBody;
import com.hederahashgraph.api.proto.java.TransactionBody;
import com.hederahashgraph.api.proto.java.TransactionID;
import com.hederahashgraph.api.proto.java.TransferList;
import com.hederahashgraph.api.proto.java.UtilPrngTransactionBody;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseOperationUsage {
    static final Logger log = LogManager.getLogger(BaseOperationUsage.class);
    public static final int CANONICAL_NUM_CONTRACT_KV_PAIRS = 64;
    public static final long THREE_MONTHS_IN_SECONDS = 7776000L;
    private static final ByteString CANONICAL_SIG = ByteString.copyFromUtf8((String)"0123456789012345678901234567890123456789012345678901234567890123");
    private static final List<Long> SINGLE_SERIAL_NUM = List.of(Long.valueOf(1L));
    private static final ByteString CANONICAL_NFT_METADATA = ByteString.copyFromUtf8((String)"0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789");
    private static final SignatureMap ONE_PAIR_SIG_MAP = SignatureMap.newBuilder().addSigPair(SignaturePair.newBuilder().setPubKeyPrefix(ByteString.copyFromUtf8((String)"a")).setEd25519(CANONICAL_SIG)).build();
    private static final SignatureMap TWO_PAIR_SIG_MAP = SignatureMap.newBuilder().addSigPair(SignaturePair.newBuilder().setPubKeyPrefix(ByteString.copyFromUtf8((String)"a")).setEd25519(CANONICAL_SIG)).addSigPair(SignaturePair.newBuilder().setPubKeyPrefix(ByteString.copyFromUtf8((String)"b")).setEd25519(CANONICAL_SIG)).build();
    private static final SignatureMap FOUR_PAIR_SIG_MAP = SignatureMap.newBuilder().addSigPair(SignaturePair.newBuilder().setPubKeyPrefix(ByteString.copyFromUtf8((String)"a")).setEd25519(CANONICAL_SIG)).addSigPair(SignaturePair.newBuilder().setPubKeyPrefix(ByteString.copyFromUtf8((String)"b")).setEd25519(CANONICAL_SIG)).addSigPair(SignaturePair.newBuilder().setPubKeyPrefix(ByteString.copyFromUtf8((String)"c")).setEd25519(CANONICAL_SIG)).addSigPair(SignaturePair.newBuilder().setPubKeyPrefix(ByteString.copyFromUtf8((String)"d")).setEd25519(CANONICAL_SIG)).build();
    private static final SigUsage SINGLE_SIG_USAGE = new SigUsage(1, ONE_PAIR_SIG_MAP.getSerializedSize(), 1);
    private static final SigUsage DUAL_SIG_USAGE = new SigUsage(2, TWO_PAIR_SIG_MAP.getSerializedSize(), 1);
    private static final SigUsage QUAD_SIG_USAGE = new SigUsage(4, FOUR_PAIR_SIG_MAP.getSerializedSize(), 1);
    private static final BaseTransactionMeta NO_MEMO_AND_NO_EXPLICIT_XFERS = new BaseTransactionMeta(0, 0);
    private static final Key A_KEY = Key.newBuilder().setEd25519(ByteString.copyFromUtf8((String)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa")).build();
    private static final AccountID AN_ACCOUNT = AccountID.newBuilder().setAccountNum(1234L).build();
    private static final String A_TOKEN_NAME = "012345678912";
    private static final String A_TOKEN_SYMBOL = "ABCD";
    private static final String BLANK_MEMO = "";
    private static final TokenOpsUsage TOKEN_OPS_USAGE = new TokenOpsUsage();
    private static final ConsensusOpsUsage CONSENSUS_OPS_USAGE = new ConsensusOpsUsage();
    private static final CryptoOpsUsage CRYPTO_OPS_USAGE = new CryptoOpsUsage();
    private static final FileOpsUsage FILE_OPS_USAGE = new FileOpsUsage();
    private static final ScheduleOpsUsage SCHEDULE_OPS_USAGE = new ScheduleOpsUsage();
    private static final UtilOpsUsage UTIL_OPS_USAGE = new UtilOpsUsage();

    UsageAccumulator baseUsageFor(HederaFunctionality function, SubType type) {
        switch (function) {
            case ContractAutoRenew: {
                if (type != SubType.DEFAULT) break;
                return this.contractAutoRenew();
            }
            case FileAppend: {
                if (type != SubType.DEFAULT) break;
                return this.fileAppend();
            }
            case CryptoTransfer: {
                switch (type) {
                    case DEFAULT: {
                        return this.hbarCryptoTransfer();
                    }
                    case TOKEN_FUNGIBLE_COMMON: {
                        return this.htsCryptoTransfer();
                    }
                    case TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES: {
                        return this.htsCryptoTransferWithCustomFee();
                    }
                    case TOKEN_NON_FUNGIBLE_UNIQUE: {
                        return this.nftCryptoTransfer();
                    }
                    case TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES: {
                        return this.nftCryptoTransferWithCustomFee();
                    }
                }
                break;
            }
            case CryptoCreate: {
                if (type != SubType.DEFAULT) break;
                return this.cryptoCreate(0);
            }
            case CryptoUpdate: {
                if (type != SubType.DEFAULT) break;
                return this.cryptoUpdate(0);
            }
            case CryptoApproveAllowance: {
                if (type != SubType.DEFAULT) break;
                return this.cryptoApproveAllowance();
            }
            case CryptoDeleteAllowance: {
                if (type != SubType.DEFAULT) break;
                return this.cryptoDeleteAllowance();
            }
            case TokenCreate: {
                switch (type) {
                    case TOKEN_FUNGIBLE_COMMON: {
                        return this.fungibleTokenCreate();
                    }
                    case TOKEN_NON_FUNGIBLE_UNIQUE: {
                        return this.uniqueTokenCreate();
                    }
                    case TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES: {
                        return this.fungibleTokenCreateWithCustomFees();
                    }
                    case TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES: {
                        return this.uniqueTokenCreateWithCustomFees();
                    }
                }
                break;
            }
            case TokenMint: {
                if (type == SubType.TOKEN_NON_FUNGIBLE_UNIQUE) {
                    return this.uniqueTokenMint();
                }
                if (type != SubType.TOKEN_FUNGIBLE_COMMON) break;
                return this.fungibleCommonTokenMint();
            }
            case TokenAccountWipe: {
                if (type == SubType.TOKEN_NON_FUNGIBLE_UNIQUE) {
                    return this.uniqueTokenWipe();
                }
                if (type != SubType.TOKEN_FUNGIBLE_COMMON) break;
                return this.fungibleCommonTokenWipe();
            }
            case TokenBurn: {
                if (type == SubType.TOKEN_NON_FUNGIBLE_UNIQUE) {
                    return this.uniqueTokenBurn();
                }
                if (type != SubType.TOKEN_FUNGIBLE_COMMON) break;
                return this.fungibleCommonTokenBurn();
            }
            case ScheduleCreate: {
                if (type == SubType.SCHEDULE_CREATE_CONTRACT_CALL) {
                    return this.scheduleCreateWithContractCall();
                }
                if (type != SubType.DEFAULT) break;
                return this.scheduleCreate();
            }
            case TokenFreezeAccount: {
                return this.tokenFreezeAccount();
            }
            case TokenUnfreezeAccount: {
                return this.tokenUnfreezeAccount();
            }
            case TokenFeeScheduleUpdate: {
                return this.feeScheduleUpdate();
            }
            case TokenPause: {
                return this.tokenPause();
            }
            case TokenUnpause: {
                return this.tokenUnpause();
            }
            case ConsensusSubmitMessage: {
                return this.submitMessage();
            }
            case UtilPrng: {
                return this.utilPrng();
            }
        }
        throw new IllegalArgumentException("Canonical usage unknown");
    }

    UsageAccumulator contractAutoRenew() {
        ExtantCryptoContext accountContext = ExtantCryptoContext.newBuilder().setCurrentExpiry(0L).setCurrentMemo(BLANK_MEMO).setCurrentKey(A_KEY).setCurrentlyHasProxy(false).setCurrentNumTokenRels(0).setCurrentMaxAutomaticAssociations(0).setCurrentCryptoAllowances(Collections.emptyList()).setCurrentTokenAllowances(Collections.emptyList()).setCurrentApproveForAllNftAllowances(Collections.emptyList()).setCurrentMaxAutomaticAssociations(0).build();
        ExtantContractContext contractContext = new ExtantContractContext(64, accountContext);
        UsageAccumulator into = new UsageAccumulator();
        into.addRbs(7776000L * contractContext.currentRb());
        return into;
    }

    UsageAccumulator utilPrng() {
        UtilPrngTransactionBody prngTxnBody = UtilPrngTransactionBody.newBuilder().build();
        UtilPrngMeta prngMeta = new UtilPrngMeta(prngTxnBody);
        UsageAccumulator into = new UsageAccumulator();
        UTIL_OPS_USAGE.prngUsage(SINGLE_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, prngMeta, into);
        return into;
    }

    UsageAccumulator cryptoCreate(int autoAssocSlots) {
        CryptoCreateTransactionBody cryptoCreateTxnBody = CryptoCreateTransactionBody.newBuilder().setMemo(BLANK_MEMO).setMaxAutomaticTokenAssociations(autoAssocSlots).setAutoRenewPeriod(Duration.newBuilder().setSeconds(7776000L)).setKey(A_KEY).build();
        CryptoCreateMeta cryptoCreateMeta = new CryptoCreateMeta(cryptoCreateTxnBody);
        UsageAccumulator into = new UsageAccumulator();
        CRYPTO_OPS_USAGE.cryptoCreateUsage(SINGLE_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, cryptoCreateMeta, into);
        return into;
    }

    UsageAccumulator cryptoApproveAllowance() {
        long now = Instant.now().getEpochSecond();
        TransactionBody canonicalTxn = TransactionBody.newBuilder().setCryptoApproveAllowance(CryptoApproveAllowanceTransactionBody.newBuilder().addCryptoAllowances(CryptoAllowance.newBuilder().setSpender(AN_ACCOUNT).setAmount(1L).build())).build();
        ExtantCryptoContext ctx = ExtantCryptoContext.newBuilder().setCurrentExpiry(now + 7776000L).setCurrentMemo(BLANK_MEMO).setCurrentKey(A_KEY).setCurrentlyHasProxy(false).setCurrentNumTokenRels(0).setCurrentMaxAutomaticAssociations(0).setCurrentCryptoAllowances(Collections.emptyMap()).setCurrentTokenAllowances(Collections.emptyMap()).setCurrentApproveForAllNftAllowances(Collections.emptySet()).build();
        CryptoApproveAllowanceMeta cryptoApproveMeta = new CryptoApproveAllowanceMeta(canonicalTxn.getCryptoApproveAllowance(), now);
        UsageAccumulator into = new UsageAccumulator();
        CRYPTO_OPS_USAGE.cryptoApproveAllowanceUsage(SINGLE_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, cryptoApproveMeta, ctx, into);
        return into;
    }

    UsageAccumulator cryptoDeleteAllowance() {
        long now = Instant.now().getEpochSecond();
        TokenID target = TokenID.newBuilder().setTokenNum(1234L).build();
        TransactionBody canonicalTxn = TransactionBody.newBuilder().setCryptoDeleteAllowance(CryptoDeleteAllowanceTransactionBody.newBuilder().addNftAllowances(NftRemoveAllowance.newBuilder().setOwner(AN_ACCOUNT).setTokenId(target).addAllSerialNumbers(SINGLE_SERIAL_NUM).build())).build();
        CryptoDeleteAllowanceMeta cryptoDeleteAllowanceMeta = new CryptoDeleteAllowanceMeta(canonicalTxn.getCryptoDeleteAllowance(), now);
        UsageAccumulator into = new UsageAccumulator();
        CRYPTO_OPS_USAGE.cryptoDeleteAllowanceUsage(SINGLE_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, cryptoDeleteAllowanceMeta, into);
        return into;
    }

    UsageAccumulator cryptoUpdate(int newAutoAssocSlots) {
        long now = Instant.now().getEpochSecond();
        TransactionBody canonicalTxn = TransactionBody.newBuilder().setCryptoUpdateAccount(CryptoUpdateTransactionBody.newBuilder().setMemo(StringValue.of((String)BLANK_MEMO)).setExpirationTime(Timestamp.newBuilder().setSeconds(now + 7776000L)).setMaxAutomaticTokenAssociations(Int32Value.newBuilder().setValue(newAutoAssocSlots)).setAccountIDToUpdate(AN_ACCOUNT)).build();
        ExtantCryptoContext ctx = ExtantCryptoContext.newBuilder().setCurrentExpiry(now).setCurrentMemo(BLANK_MEMO).setCurrentKey(A_KEY).setCurrentlyHasProxy(false).setCurrentNumTokenRels(0).setCurrentMaxAutomaticAssociations(0).setCurrentCryptoAllowances(Collections.emptyMap()).setCurrentTokenAllowances(Collections.emptyMap()).setCurrentApproveForAllNftAllowances(Collections.emptySet()).build();
        CryptoUpdateMeta cryptoUpdateMeta = new CryptoUpdateMeta(canonicalTxn.getCryptoUpdateAccount(), now);
        UsageAccumulator into = new UsageAccumulator();
        CRYPTO_OPS_USAGE.cryptoUpdateUsage(SINGLE_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, cryptoUpdateMeta, ctx, into, 0L);
        return into;
    }

    UsageAccumulator fileAppend() {
        FileAppendMeta opMeta = new FileAppendMeta(1000, 7776000L);
        UsageAccumulator into = new UsageAccumulator();
        FILE_OPS_USAGE.fileAppendUsage(SINGLE_SIG_USAGE, opMeta, NO_MEMO_AND_NO_EXPLICIT_XFERS, into);
        return into;
    }

    UsageAccumulator tokenFreezeAccount() {
        TokenFreezeMeta tokenFreezeMeta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenFreezeUsageFrom();
        UsageAccumulator into = new UsageAccumulator();
        TOKEN_OPS_USAGE.tokenFreezeUsage(SINGLE_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, tokenFreezeMeta, into);
        log.info("TokenFreeze base accumulator: {}", (Object)into);
        return into;
    }

    UsageAccumulator tokenUnfreezeAccount() {
        TokenUnfreezeMeta tokenUnfreezeMeta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenUnfreezeUsageFrom();
        UsageAccumulator into = new UsageAccumulator();
        TOKEN_OPS_USAGE.tokenFreezeUsage(SINGLE_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, tokenUnfreezeMeta, into);
        return into;
    }

    UsageAccumulator tokenPause() {
        TokenPauseMeta tokenPauseMeta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenPauseUsageFrom();
        UsageAccumulator into = new UsageAccumulator();
        TOKEN_OPS_USAGE.tokenPauseUsage(SINGLE_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, tokenPauseMeta, into);
        return into;
    }

    UsageAccumulator tokenUnpause() {
        TokenUnpauseMeta tokenUnpauseMeta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenUnpauseUsageFrom();
        UsageAccumulator into = new UsageAccumulator();
        TOKEN_OPS_USAGE.tokenUnpauseUsage(SINGLE_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, tokenUnpauseMeta, into);
        return into;
    }

    UsageAccumulator uniqueTokenBurn() {
        TokenID target = TokenID.newBuilder().setTokenNum(1234L).build();
        TransactionBody canonicalTxn = TransactionBody.newBuilder().setTokenBurn(TokenBurnTransactionBody.newBuilder().setToken(target).addAllSerialNumbers(SINGLE_SERIAL_NUM)).build();
        TokenBurnMeta tokenBurnMeta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenBurnUsageFrom(canonicalTxn, SubType.TOKEN_NON_FUNGIBLE_UNIQUE);
        UsageAccumulator into = new UsageAccumulator();
        TOKEN_OPS_USAGE.tokenBurnUsage(SINGLE_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, tokenBurnMeta, into);
        return into;
    }

    UsageAccumulator fungibleCommonTokenBurn() {
        TokenID target = TokenID.newBuilder().setTokenNum(1235L).build();
        TransactionBody canonicalTxn = TransactionBody.newBuilder().setTokenBurn(TokenBurnTransactionBody.newBuilder().setToken(target).setAmount(1000L)).build();
        TokenBurnMeta tokenBurnMeta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenBurnUsageFrom(canonicalTxn, SubType.TOKEN_FUNGIBLE_COMMON);
        UsageAccumulator into = new UsageAccumulator();
        TOKEN_OPS_USAGE.tokenBurnUsage(SINGLE_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, tokenBurnMeta, into);
        return into;
    }

    UsageAccumulator uniqueTokenMint() {
        TokenID target = TokenID.newBuilder().setTokenNum(1234L).build();
        TransactionBody canonicalTxn = TransactionBody.newBuilder().setTokenMint(TokenMintTransactionBody.newBuilder().setToken(target).addMetadata(CANONICAL_NFT_METADATA)).build();
        TokenMintMeta tokenMintMeta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenMintUsageFrom(canonicalTxn, SubType.TOKEN_NON_FUNGIBLE_UNIQUE, 7776000L);
        UsageAccumulator into = new UsageAccumulator();
        TOKEN_OPS_USAGE.tokenMintUsage(SINGLE_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, tokenMintMeta, into, SubType.TOKEN_NON_FUNGIBLE_UNIQUE);
        return into;
    }

    UsageAccumulator fungibleCommonTokenMint() {
        TokenID target = TokenID.newBuilder().setTokenNum(1234L).build();
        TransactionBody canonicalTxn = TransactionBody.newBuilder().setTokenMint(TokenMintTransactionBody.newBuilder().setToken(target).setAmount(1000L)).build();
        TokenMintMeta tokenMintMeta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenMintUsageFrom(canonicalTxn, SubType.TOKEN_FUNGIBLE_COMMON, 7776000L);
        UsageAccumulator into = new UsageAccumulator();
        TOKEN_OPS_USAGE.tokenMintUsage(SINGLE_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, tokenMintMeta, into, SubType.TOKEN_FUNGIBLE_COMMON);
        return into;
    }

    UsageAccumulator uniqueTokenWipe() {
        TokenID target = TokenID.newBuilder().setTokenNum(1234L).build();
        AccountID targetAcct = AccountID.newBuilder().setAccountNum(5678L).build();
        TransactionBody canonicalTxn = TransactionBody.newBuilder().setTokenWipe(TokenWipeAccountTransactionBody.newBuilder().setToken(target).setAccount(targetAcct).addAllSerialNumbers(SINGLE_SERIAL_NUM)).build();
        TokenWipeMeta tokenWipeMeta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenWipeUsageFrom(canonicalTxn.getTokenWipe());
        UsageAccumulator into = new UsageAccumulator();
        TOKEN_OPS_USAGE.tokenWipeUsage(SINGLE_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, tokenWipeMeta, into);
        return into;
    }

    UsageAccumulator fungibleCommonTokenWipe() {
        TokenID target = TokenID.newBuilder().setTokenNum(1234L).build();
        AccountID targetAcct = AccountID.newBuilder().setAccountNum(5678L).build();
        TransactionBody canonicalTxn = TransactionBody.newBuilder().setTokenWipe(TokenWipeAccountTransactionBody.newBuilder().setToken(target).setAccount(targetAcct).setAmount(100L)).build();
        TokenWipeMeta tokenWipeMeta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenWipeUsageFrom(canonicalTxn.getTokenWipe());
        UsageAccumulator into = new UsageAccumulator();
        TOKEN_OPS_USAGE.tokenWipeUsage(SINGLE_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, tokenWipeMeta, into);
        return into;
    }

    UsageAccumulator fungibleTokenCreateWithCustomFees() {
        TransactionBody canonicalTxn = TransactionBody.newBuilder().setTokenCreation(TokenCreateTransactionBody.newBuilder().setAutoRenewAccount(AN_ACCOUNT).setTreasury(AN_ACCOUNT).setName(A_TOKEN_NAME).setSymbol(A_TOKEN_SYMBOL).setAdminKey(A_KEY).setFeeScheduleKey(A_KEY).setAutoRenewPeriod(Duration.newBuilder().setSeconds(7776000L)).setTokenType(TokenType.FUNGIBLE_COMMON).addCustomFees(CustomFee.newBuilder().setFeeCollectorAccountId(AN_ACCOUNT).setAllCollectorsAreExempt(false).setFixedFee(FixedFee.newBuilder().setAmount(100000000L).build()))).build();
        TokenCreateMeta tokenCreateMeta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenCreateUsageFrom(canonicalTxn);
        UsageAccumulator into = new UsageAccumulator();
        TOKEN_OPS_USAGE.tokenCreateUsage(QUAD_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, tokenCreateMeta, into);
        return into;
    }

    UsageAccumulator fungibleTokenCreate() {
        TransactionBody canonicalTxn = TransactionBody.newBuilder().setTokenCreation(TokenCreateTransactionBody.newBuilder().setTreasury(AN_ACCOUNT).setAutoRenewAccount(AN_ACCOUNT).setName(A_TOKEN_NAME).setSymbol(A_TOKEN_SYMBOL).setAdminKey(A_KEY).setAutoRenewPeriod(Duration.newBuilder().setSeconds(7776000L)).setTokenType(TokenType.FUNGIBLE_COMMON)).build();
        TokenCreateMeta tokenCreateMeta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenCreateUsageFrom(canonicalTxn);
        UsageAccumulator into = new UsageAccumulator();
        TOKEN_OPS_USAGE.tokenCreateUsage(QUAD_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, tokenCreateMeta, into);
        return into;
    }

    UsageAccumulator uniqueTokenCreate() {
        TransactionBody canonicalTxn = TransactionBody.newBuilder().setTokenCreation(TokenCreateTransactionBody.newBuilder().setTreasury(AN_ACCOUNT).setAutoRenewAccount(AN_ACCOUNT).setInitialSupply(0L).setName(A_TOKEN_NAME).setSymbol(A_TOKEN_SYMBOL).setAdminKey(A_KEY).setSupplyKey(A_KEY).setAutoRenewPeriod(Duration.newBuilder().setSeconds(7776000L)).setTokenType(TokenType.NON_FUNGIBLE_UNIQUE)).build();
        TokenCreateMeta tokenCreateMeta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenCreateUsageFrom(canonicalTxn);
        UsageAccumulator into = new UsageAccumulator();
        TOKEN_OPS_USAGE.tokenCreateUsage(QUAD_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, tokenCreateMeta, into);
        return into;
    }

    UsageAccumulator uniqueTokenCreateWithCustomFees() {
        TransactionBody canonicalTxn = TransactionBody.newBuilder().setTokenCreation(TokenCreateTransactionBody.newBuilder().setAutoRenewAccount(AN_ACCOUNT).setTreasury(AN_ACCOUNT).setTokenType(TokenType.NON_FUNGIBLE_UNIQUE).setInitialSupply(0L).setName(A_TOKEN_NAME).setSymbol(A_TOKEN_SYMBOL).setAdminKey(A_KEY).setSupplyKey(A_KEY).setFeeScheduleKey(A_KEY).setAutoRenewPeriod(Duration.newBuilder().setSeconds(7776000L)).setTokenType(TokenType.NON_FUNGIBLE_UNIQUE).addCustomFees(CustomFee.newBuilder().setFeeCollectorAccountId(AN_ACCOUNT).setFixedFee(FixedFee.newBuilder().setAmount(100000000L).build()))).build();
        TokenCreateMeta tokenCreateMeta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenCreateUsageFrom(canonicalTxn);
        UsageAccumulator into = new UsageAccumulator();
        TOKEN_OPS_USAGE.tokenCreateUsage(QUAD_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, tokenCreateMeta, into);
        return into;
    }

    UsageAccumulator submitMessage() {
        SubmitMessageMeta opMeta = new SubmitMessageMeta(100, 0L);
        UsageAccumulator into = new UsageAccumulator();
        CONSENSUS_OPS_USAGE.submitMessageUsage(SINGLE_SIG_USAGE, opMeta, NO_MEMO_AND_NO_EXPLICIT_XFERS, into);
        return into;
    }

    UsageAccumulator feeScheduleUpdate() {
        TokenID target = TokenID.newBuilder().setShardNum(1L).setRealmNum(2L).setTokenNum(3L).build();
        List<CustomFee> theNewSchedule = List.of(CustomFee.newBuilder().setFixedFee(FixedFee.newBuilder().setAmount(123L).setDenominatingTokenId(target)).build());
        int newReprBytes = TOKEN_OPS_USAGE.bytesNeededToRepr(theNewSchedule);
        FeeScheduleUpdateMeta opMeta = new FeeScheduleUpdateMeta(0L, newReprBytes);
        ExtantFeeScheduleContext feeScheduleCtx = new ExtantFeeScheduleContext(7776000L, 0);
        UsageAccumulator into = new UsageAccumulator();
        TOKEN_OPS_USAGE.feeScheduleUpdateUsage(SINGLE_SIG_USAGE, NO_MEMO_AND_NO_EXPLICIT_XFERS, opMeta, feeScheduleCtx, into);
        return into;
    }

    UsageAccumulator hbarCryptoTransfer() {
        BaseTransactionMeta txnUsageMeta = new BaseTransactionMeta(0, 2);
        CryptoTransferMeta xferUsageMeta = new CryptoTransferMeta(380, 0, 0, 0, false);
        UsageAccumulator into = new UsageAccumulator();
        CRYPTO_OPS_USAGE.cryptoTransferUsage(SINGLE_SIG_USAGE, xferUsageMeta, txnUsageMeta, into, 0L, false);
        return into;
    }

    UsageAccumulator htsCryptoTransfer() {
        CryptoTransferMeta xferUsageMeta = new CryptoTransferMeta(380, 1, 2, 0, false);
        UsageAccumulator into = new UsageAccumulator();
        CRYPTO_OPS_USAGE.cryptoTransferUsage(SINGLE_SIG_USAGE, xferUsageMeta, NO_MEMO_AND_NO_EXPLICIT_XFERS, into, 0L, false);
        return into;
    }

    UsageAccumulator htsCryptoTransferWithCustomFee() {
        CryptoTransferMeta xferUsageMeta = new CryptoTransferMeta(380, 1, 2, 0, false);
        xferUsageMeta.setCustomFeeHbarTransfers(2);
        UsageAccumulator into = new UsageAccumulator();
        CRYPTO_OPS_USAGE.cryptoTransferUsage(SINGLE_SIG_USAGE, xferUsageMeta, NO_MEMO_AND_NO_EXPLICIT_XFERS, into, 0L, false);
        return into;
    }

    UsageAccumulator nftCryptoTransfer() {
        CryptoTransferMeta xferUsageMeta = new CryptoTransferMeta(380, 1, 0, 1, false);
        UsageAccumulator into = new UsageAccumulator();
        CRYPTO_OPS_USAGE.cryptoTransferUsage(SINGLE_SIG_USAGE, xferUsageMeta, NO_MEMO_AND_NO_EXPLICIT_XFERS, into, 0L, false);
        return into;
    }

    UsageAccumulator nftCryptoTransferWithCustomFee() {
        CryptoTransferMeta xferUsageMeta = new CryptoTransferMeta(380, 1, 0, 1, false);
        xferUsageMeta.setCustomFeeHbarTransfers(2);
        UsageAccumulator into = new UsageAccumulator();
        CRYPTO_OPS_USAGE.cryptoTransferUsage(SINGLE_SIG_USAGE, xferUsageMeta, NO_MEMO_AND_NO_EXPLICIT_XFERS, into, 0L, false);
        return into;
    }

    UsageAccumulator scheduleCreate() {
        TransactionBody txn = TransactionBody.newBuilder().setTransactionID(TransactionID.newBuilder().setTransactionValidStart(Timestamp.newBuilder().setNanos(1).setSeconds(1L).build()).setAccountID(AN_ACCOUNT).build()).setNodeAccountID(AN_ACCOUNT).setScheduleCreate(ScheduleCreateTransactionBody.newBuilder().setAdminKey(A_KEY).setScheduledTransactionBody(SchedulableTransactionBody.newBuilder().setCryptoTransfer(CryptoTransferTransactionBody.newBuilder().setTransfers(TransferList.newBuilder().addAccountAmounts(AccountAmount.newBuilder().setAmount(-1000000000L).setAccountID(AN_ACCOUNT)).addAccountAmounts(AccountAmount.newBuilder().setAmount(1000000000L).setAccountID(AN_ACCOUNT)))).setMemo(BLANK_MEMO).setTransactionFee(100000000L).build())).build();
        FeeData feeData = SCHEDULE_OPS_USAGE.scheduleCreateUsage(txn, DUAL_SIG_USAGE, 1800L);
        return UsageAccumulator.fromGrpc(feeData);
    }

    UsageAccumulator scheduleCreateWithContractCall() {
        TransactionBody txn = TransactionBody.newBuilder().setTransactionID(TransactionID.newBuilder().setTransactionValidStart(Timestamp.newBuilder().setNanos(1).setSeconds(1L).build()).setAccountID(AN_ACCOUNT).build()).setNodeAccountID(AN_ACCOUNT).setScheduleCreate(ScheduleCreateTransactionBody.newBuilder().setAdminKey(A_KEY).setScheduledTransactionBody(SchedulableTransactionBody.newBuilder().setContractCall(ContractCallTransactionBody.newBuilder().setContractID(ContractID.newBuilder().setShardNum(1L).setRealmNum(1L).setContractNum(1L).build()).setGas(10000L).setFunctionParameters(ByteString.copyFrom((byte[])new byte[]{1, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68}))).setMemo(BLANK_MEMO).setTransactionFee(100000000L).build())).build();
        FeeData feeData = SCHEDULE_OPS_USAGE.scheduleCreateUsage(txn, SINGLE_SIG_USAGE, 1800L);
        return UsageAccumulator.fromGrpc(feeData);
    }
}

