/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage;

import com.hedera.node.app.hapi.fees.usage.SingletonUsageProperties;
import com.hedera.node.app.hapi.fees.usage.TxnUsageEstimator;
import com.hedera.node.app.hapi.fees.usage.UsageProperties;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.TransactionBody;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class TxnUsage {
    protected static final int AMOUNT_REPR_BYTES = 8;
    protected static final UsageProperties usageProperties = SingletonUsageProperties.USAGE_PROPERTIES;
    protected final TransactionBody op;
    protected final TxnUsageEstimator usageEstimator;

    protected TxnUsage(TransactionBody op, TxnUsageEstimator usageEstimator) {
        this.op = op;
        this.usageEstimator = usageEstimator;
    }

    public static <T> long keySizeIfPresent(T op, Predicate<T> check, Function<T, Key> getter) {
        return check.test(op) ? (long)FeeBuilder.getAccountKeyStorageSize((Key)getter.apply(op)) : 0L;
    }

    protected void addAmountBpt() {
        this.usageEstimator.addBpt(8L);
    }

    protected void addEntityBpt() {
        this.usageEstimator.addBpt(24L);
    }

    protected void addNetworkRecordRb(long rb) {
        this.usageEstimator.addNetworkRbs(rb * usageProperties.legacyReceiptStorageSecs());
    }

    protected void addRecordRb(long rb) {
        this.usageEstimator.addRbs(rb * usageProperties.legacyReceiptStorageSecs());
    }
}

