/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage;

import com.hedera.node.app.hapi.fees.usage.EstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.UsageEstimate;
import com.hederahashgraph.api.proto.java.FeeComponents;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.SubType;
import com.hederahashgraph.api.proto.java.TransactionBody;

public class TxnUsageEstimator {
    private final SigUsage sigUsage;
    private final TransactionBody txn;
    private final EstimatorUtils utils;
    private long bpt;
    private long vpt;
    private long rbs;
    private long sbs;
    private long gas;
    private long tv;
    private long networkRbs;

    public TxnUsageEstimator(SigUsage sigUsage, TransactionBody txn, EstimatorUtils utils) {
        this.txn = txn;
        this.utils = utils;
        this.sigUsage = sigUsage;
    }

    public FeeData get() {
        return this.get(SubType.DEFAULT);
    }

    public FeeData get(SubType subType) {
        UsageEstimate usage = this.utils.baseEstimate(this.txn, this.sigUsage);
        this.customize(usage);
        return this.utils.withDefaultTxnPartitioning(usage.build(), subType, this.utils.nonDegenerateDiv(this.networkRbs, 3600), this.sigUsage.numPayerKeys());
    }

    private void customize(UsageEstimate usage) {
        FeeComponents.Builder baseUsage = usage.base();
        baseUsage.setBpt(baseUsage.getBpt() + this.bpt).setVpt(baseUsage.getVpt() + this.vpt).setGas(baseUsage.getGas() + this.gas).setTv(baseUsage.getTv() + this.tv);
        usage.addRbs(this.rbs);
        usage.addSbs(this.sbs);
        this.networkRbs += this.utils.baseNetworkRbs();
    }

    public TxnUsageEstimator addBpt(long bpt) {
        this.bpt += bpt;
        return this;
    }

    public TxnUsageEstimator addVpt(long vpt) {
        this.vpt += vpt;
        return this;
    }

    public TxnUsageEstimator addRbs(long rbs) {
        this.rbs += rbs;
        return this;
    }

    public TxnUsageEstimator addSbs(long sbs) {
        this.sbs += sbs;
        return this;
    }

    public TxnUsageEstimator addGas(long gas) {
        this.gas += gas;
        return this;
    }

    public TxnUsageEstimator addTv(long tv) {
        this.tv += tv;
        return this;
    }

    public TxnUsageEstimator addNetworkRbs(long networkRbs) {
        this.networkRbs += networkRbs;
        return this;
    }

    public SigUsage getSigUsage() {
        return this.sigUsage;
    }
}

