/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.file;

import com.hedera.node.app.hapi.fees.usage.BaseTransactionMeta;
import com.hedera.node.app.hapi.fees.usage.EstimatorFactory;
import com.hedera.node.app.hapi.fees.usage.QueryUsage;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.SingletonEstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.SingletonUsageProperties;
import com.hedera.node.app.hapi.fees.usage.TxnUsage;
import com.hedera.node.app.hapi.fees.usage.TxnUsageEstimator;
import com.hedera.node.app.hapi.fees.usage.file.ExtantFileContext;
import com.hedera.node.app.hapi.fees.usage.file.FileAppendMeta;
import com.hedera.node.app.hapi.fees.usage.state.UsageAccumulator;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.FileCreateTransactionBody;
import com.hederahashgraph.api.proto.java.FileGetInfoQuery;
import com.hederahashgraph.api.proto.java.FileUpdateTransactionBody;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.KeyList;
import com.hederahashgraph.api.proto.java.Query;
import com.hederahashgraph.api.proto.java.ResponseType;
import com.hederahashgraph.api.proto.java.TransactionBody;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FileOpsUsage {
    private static final long LONG_BASIC_ENTITY_ID_SIZE = 24L;
    static EstimatorFactory txnEstimateFactory = TxnUsageEstimator::new;
    static Function<ResponseType, QueryUsage> queryEstimateFactory = QueryUsage::new;
    private static final int NUM_FLAGS_IN_BASE_FILE_REPR = 1;
    private static final int NUM_LONG_FIELDS_IN_BASE_FILE_REPR = 1;

    static int bytesInBaseRepr() {
        return 12;
    }

    @Inject
    public FileOpsUsage() {
    }

    public void fileAppendUsage(SigUsage sigUsage, FileAppendMeta appendMeta, BaseTransactionMeta baseMeta, UsageAccumulator accumulator) {
        accumulator.resetForTransaction(baseMeta, sigUsage);
        int bytesAdded = appendMeta.bytesAdded();
        accumulator.addBpt(24L + (long)bytesAdded);
        accumulator.addSbs((long)bytesAdded * appendMeta.lifetime());
    }

    public FeeData fileCreateUsage(TransactionBody fileCreation, SigUsage sigUsage) {
        FileCreateTransactionBody op = fileCreation.getFileCreate();
        long customBytes = 0L;
        customBytes += (long)op.getContents().size();
        customBytes += (long)op.getMemoBytes().size();
        long lifetime = SingletonEstimatorUtils.ESTIMATOR_UTILS.relativeLifetime(fileCreation, op.getExpirationTime().getSeconds());
        TxnUsageEstimator estimate = txnEstimateFactory.get(sigUsage, fileCreation, SingletonEstimatorUtils.ESTIMATOR_UTILS);
        estimate.addBpt((customBytes += TxnUsage.keySizeIfPresent(op, FileCreateTransactionBody::hasKeys, body -> FileOpsUsage.asKey(body.getKeys()))) + 8L);
        estimate.addSbs(((long)FileOpsUsage.bytesInBaseRepr() + customBytes) * lifetime);
        estimate.addNetworkRbs(24L * SingletonUsageProperties.USAGE_PROPERTIES.legacyReceiptStorageSecs());
        return estimate.get();
    }

    public FeeData fileInfoUsage(Query fileInfoReq, ExtantFileContext ctx) {
        FileGetInfoQuery op = fileInfoReq.getFileGetInfo();
        QueryUsage estimate = queryEstimateFactory.apply(op.getHeader().getResponseType());
        estimate.addTb(24L);
        long extraSb = 0L;
        extraSb += (long)ctx.currentMemo().getBytes(StandardCharsets.UTF_8).length;
        estimate.addSb(44L + (extraSb += (long)FeeBuilder.getAccountKeyStorageSize((Key)FileOpsUsage.asKey(ctx.currentWacl()))));
        return estimate.get();
    }

    public FeeData fileUpdateUsage(TransactionBody fileUpdate, SigUsage sigUsage, ExtantFileContext ctx) {
        FileUpdateTransactionBody op = fileUpdate.getFileUpdate();
        long keyBytesUsed = op.hasKeys() ? (long)FeeBuilder.getAccountKeyStorageSize((Key)FileOpsUsage.asKey(op.getKeys())) : 0L;
        long msgBytesUsed = (long)(24 + op.getContents().size() + op.getMemo().getValueBytes().size()) + keyBytesUsed + (long)(op.hasExpirationTime() ? 8 : 0);
        TxnUsageEstimator estimate = txnEstimateFactory.get(sigUsage, fileUpdate, SingletonEstimatorUtils.ESTIMATOR_UTILS);
        estimate.addBpt(msgBytesUsed);
        long newCustomBytes = 0L;
        newCustomBytes += op.getContents().isEmpty() ? ctx.currentSize() : (long)op.getContents().size();
        newCustomBytes += !op.hasMemo() ? (long)ctx.currentMemo().getBytes(StandardCharsets.UTF_8).length : (long)op.getMemo().getValueBytes().size();
        long l = !op.hasKeys() ? (long)FeeBuilder.getAccountKeyStorageSize((Key)FileOpsUsage.asKey(ctx.currentWacl())) : keyBytesUsed;
        long oldCustomBytes = ctx.currentNonBaseSb();
        long oldLifetime = SingletonEstimatorUtils.ESTIMATOR_UTILS.relativeLifetime(fileUpdate, ctx.currentExpiry());
        long newLifetime = SingletonEstimatorUtils.ESTIMATOR_UTILS.relativeLifetime(fileUpdate, op.getExpirationTime().getSeconds());
        long sbsDelta = SingletonEstimatorUtils.ESTIMATOR_UTILS.changeInBsUsage(oldCustomBytes, oldLifetime, newCustomBytes += l, newLifetime);
        if (sbsDelta > 0L) {
            estimate.addSbs(sbsDelta);
        }
        return estimate.get();
    }

    public static Key asKey(KeyList wacl) {
        return Key.newBuilder().setKeyList(wacl).build();
    }
}

