/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.hapi.fees;

import com.hedera.hapi.node.base.HederaFunctionality;
import java.util.Objects;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.ExtraFeeDefinition;
import org.hiero.hapi.support.fees.ExtraFeeReference;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;
import org.hiero.hapi.support.fees.ServiceFeeSchedule;

public class FeeScheduleUtils {
    public static ExtraFeeDefinition makeExtraDef(Extra extra, long fee) {
        return ExtraFeeDefinition.newBuilder().name(extra).fee(fee).build();
    }

    public static ExtraFeeReference makeExtraIncluded(Extra extra, int included) {
        return ExtraFeeReference.DEFAULT.copyBuilder().name(extra).includedCount(included).build();
    }

    public static ServiceFeeDefinition makeServiceFee(HederaFunctionality name, long baseFee, ExtraFeeReference ... reference) {
        return ServiceFeeDefinition.DEFAULT.copyBuilder().name(name).baseFee(baseFee).extras(reference).build();
    }

    public static ServiceFeeSchedule makeService(String name, ServiceFeeDefinition ... services) {
        return ServiceFeeSchedule.DEFAULT.copyBuilder().name(name).schedule(services).build();
    }

    public static ExtraFeeDefinition lookupExtraFee(FeeSchedule feeSchedule, ExtraFeeReference ref) {
        for (ExtraFeeDefinition def : feeSchedule.extras()) {
            if (!def.name().equals((Object)ref.name())) continue;
            return def;
        }
        return null;
    }

    public static ServiceFeeDefinition lookupServiceFee(FeeSchedule feeSchedule, HederaFunctionality api) {
        for (ServiceFeeSchedule service : feeSchedule.services()) {
            for (ServiceFeeDefinition def : service.schedule()) {
                if (def.name() != api) continue;
                return def;
            }
        }
        return null;
    }

    public static boolean isValid(FeeSchedule feeSchedule) {
        Objects.requireNonNull(feeSchedule);
        for (ExtraFeeDefinition def : feeSchedule.extras()) {
            if (def.fee() < 0L) {
                return false;
            }
            if (def.fee() <= Long.MAX_VALUE) continue;
            return false;
        }
        for (ServiceFeeSchedule service : feeSchedule.services()) {
            for (ServiceFeeDefinition def : service.schedule()) {
                for (ExtraFeeReference ref : def.extras()) {
                    FeeScheduleUtils.lookupExtraFee(feeSchedule, ref);
                }
            }
        }
        if (feeSchedule.node() == null) {
            return false;
        }
        for (ExtraFeeReference ref : feeSchedule.node().extras()) {
            FeeScheduleUtils.lookupExtraFee(feeSchedule, ref);
        }
        return feeSchedule.services().size() > 0;
    }
}

