/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http2;

import io.helidon.webserver.http2.Http2ConcurrentConnectionStreams;
import io.helidon.webserver.http2.Http2Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

final class Http2ConnectionStreams
implements Http2ConcurrentConnectionStreams {
    private final Map<Integer, Http2Connection.StreamContext> streams = new HashMap<Integer, Http2Connection.StreamContext>(1000);
    private final Queue<Integer> forRemoval = new ConcurrentLinkedQueue<Integer>();

    Http2ConnectionStreams() {
    }

    @Override
    public void remove(int streamId) {
        this.forRemoval.add(streamId);
    }

    void put(Http2Connection.StreamContext ctx) {
        this.streams.put(ctx.stream().streamId(), ctx);
    }

    Http2Connection.StreamContext get(int streamId) {
        return this.streams.get(streamId);
    }

    Collection<Http2Connection.StreamContext> contexts() {
        return this.streams.values();
    }

    boolean isEmpty() {
        return this.streams.isEmpty();
    }

    int size() {
        return this.streams.size();
    }

    void doMaintenance(long maxConcurrentStreams) {
        if ((long)this.streams.size() < maxConcurrentStreams) {
            return;
        }
        Integer streamId = this.forRemoval.poll();
        while (streamId != null) {
            this.streams.remove(streamId);
            streamId = this.forRemoval.poll();
        }
    }
}

