/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.webserver.ServerLifecycle;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Handler
extends ServerLifecycle {
    public static Handler create(Runnable handler) {
        return (req, res) -> {
            handler.run();
            res.send();
        };
    }

    public static Handler create(Consumer<ServerRequest> handler) {
        return (req, res) -> {
            handler.accept(req);
            res.send();
        };
    }

    public static Handler create(Function<ServerRequest, ?> handler) {
        return (req, res) -> {
            Object response = handler.apply(req);
            res.send(response);
        };
    }

    public static Handler create(Supplier<?> handler) {
        return (req, res) -> {
            Object response = handler.get();
            res.send(response);
        };
    }

    public static <T> Handler create(Class<T> type, Function<T, ?> handler) {
        return (req, res) -> {
            Object response = handler.apply(req.content().as(type));
            res.send(response);
        };
    }

    public static <T> Handler create(Class<T> type, Consumer<T> handler) {
        return (req, res) -> {
            handler.accept(req.content().as(type));
            res.send();
        };
    }

    public static <T> Handler create(Class<T> type, BiConsumer<T, ServerResponse> handler) {
        return (req, res) -> handler.accept(req.content().as(type), res);
    }

    public void handle(ServerRequest var1, ServerResponse var2) throws Exception;
}

