/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto;

import java.math.BigInteger;
import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.RandomDSAKCalculator;
import org.bouncycastle.math.ec.custom.sec.SecP256R1Curve;
import org.hyperledger.besu.crypto.AbstractSECP256;
import org.hyperledger.besu.crypto.KeyPair;
import org.hyperledger.besu.crypto.SECPPublicKey;
import org.hyperledger.besu.crypto.SECPSignature;
import org.hyperledger.besu.nativelib.secp256r1.LibSECP256R1;
import org.hyperledger.besu.nativelib.secp256r1.Signature;
import org.hyperledger.besu.nativelib.secp256r1.besuNativeEC.BesuNativeEC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SECP256R1
extends AbstractSECP256 {
    private static final Logger LOG = LoggerFactory.getLogger(SECP256R1.class);
    public static final String CURVE_NAME = "secp256r1";
    private boolean useNative;
    private final LibSECP256R1 libSECP256R1 = new LibSECP256R1();

    public SECP256R1() {
        super(CURVE_NAME, SecP256R1Curve.q);
        try {
            this.useNative = BesuNativeEC.INSTANCE != null;
        }
        catch (UnsatisfiedLinkError ule) {
            LOG.info("secp256r1 native precompile not available: {}", (Object)ule.getMessage());
            this.useNative = false;
        }
    }

    @Override
    public void disableNative() {
        this.useNative = false;
    }

    @Override
    public boolean isNative() {
        return this.useNative;
    }

    @Override
    public boolean maybeEnableNative() {
        try {
            this.useNative = BesuNativeEC.INSTANCE != null;
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            LOG.info("Native secp256r1 not available - {}", (Object)e.getMessage());
            this.useNative = false;
        }
        return this.useNative;
    }

    @Override
    public DSAKCalculator getKCalculator() {
        return new RandomDSAKCalculator();
    }

    @Override
    public String getCurveName() {
        return CURVE_NAME;
    }

    @Override
    public SECPSignature sign(Bytes32 dataHash, KeyPair keyPair) {
        if (this.useNative) {
            return this.signNative(dataHash, keyPair);
        }
        return super.sign(dataHash, keyPair);
    }

    @Override
    public boolean verify(Bytes data, SECPSignature signature, SECPPublicKey pub) {
        if (this.useNative) {
            return this.verifyNative(data, signature, pub);
        }
        return super.verify(data, signature, pub);
    }

    @Override
    public Optional<SECPPublicKey> recoverPublicKeyFromSignature(Bytes32 dataHash, SECPSignature signature) {
        if (this.useNative) {
            return this.recoverPublicKeyFromSignatureNative(dataHash, signature);
        }
        return super.recoverPublicKeyFromSignature(dataHash, signature);
    }

    private SECPSignature signNative(Bytes32 dataHash, KeyPair keyPair) {
        Signature nativeSignature = this.libSECP256R1.sign(dataHash.toArrayUnsafe(), keyPair.getPrivateKey().getEncoded(), keyPair.getPublicKey().getEncoded());
        return new SECPSignature(new BigInteger(nativeSignature.getR()), new BigInteger(nativeSignature.getS()), nativeSignature.getV());
    }

    @Override
    protected BigInteger recoverFromSignature(int recId, BigInteger r, BigInteger s, Bytes32 dataHash) {
        if (this.useNative) {
            return this.recoverPublicKeyFromSignatureNative(dataHash, new SECPSignature(r, s, (byte)recId)).map(key -> new BigInteger(1, key.getEncoded())).orElse(null);
        }
        return super.recoverFromSignature(recId, r, s, dataHash);
    }

    private Optional<SECPPublicKey> recoverPublicKeyFromSignatureNative(Bytes32 dataHash, SECPSignature signature) {
        byte[] recoveredKey;
        try {
            recoveredKey = this.libSECP256R1.keyRecovery(dataHash.toArrayUnsafe(), signature.getR().toByteArray(), signature.getS().toByteArray(), (int)signature.getRecId());
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
        return Optional.of(SECPPublicKey.create(Bytes.of((byte[])recoveredKey), "ECDSA"));
    }

    private boolean verifyNative(Bytes data, SECPSignature signature, SECPPublicKey pub) {
        return this.libSECP256R1.verify(data.toArrayUnsafe(), signature.getR().toByteArray(), signature.getS().toByteArray(), pub.getEncoded());
    }
}

