/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.http.Method;
import java.util.ArrayList;
import java.util.List;

final class MethodHelper {
    private static final List<Method> KNOWN = new ArrayList<Method>(10);
    private static AsciiMethodPair[] methods;

    private MethodHelper() {
    }

    static void add(Method method) {
        KNOWN.add(method);
    }

    static void methodsDone() {
        methods = new AsciiMethodPair[KNOWN.size()];
        for (int i = 0; i < KNOWN.size(); ++i) {
            MethodHelper.methods[i] = AsciiMethodPair.create(KNOWN.get(i));
        }
        KNOWN.clear();
    }

    static Method byName(String upperCase) {
        for (AsciiMethodPair method : methods) {
            if (!method.string().equals(upperCase)) continue;
            return method.method();
        }
        return null;
    }

    private record AsciiMethodPair(String string, Method method) {
        public static AsciiMethodPair create(Method method) {
            return new AsciiMethodPair(method.text(), method);
        }
    }
}

