/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media;

import io.helidon.common.GenericType;
import io.helidon.common.buffers.BufferData;
import io.helidon.http.media.ReadableEntity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class ReadableEntityBase
implements ReadableEntity {
    private static final ReadableEntity EMPTY = new EmptyReadableEntity();
    private final AtomicBoolean consumed = new AtomicBoolean();
    private final Function<Integer, BufferData> readEntityFunction;
    private final Runnable entityProcessedRunnable;
    private final AtomicBoolean entityProcessed = new AtomicBoolean();
    private final AtomicBoolean entityRequested = new AtomicBoolean();
    private final Consumer<Boolean> entityRequestedCallback;
    private InputStream inputStream;

    protected ReadableEntityBase(Function<Integer, BufferData> readEntityFunction, Runnable entityProcessedRunnable) {
        this.entityRequestedCallback = d -> {};
        this.readEntityFunction = readEntityFunction;
        this.entityProcessedRunnable = new EntityProcessedRunnable(entityProcessedRunnable, this.entityProcessed);
    }

    protected ReadableEntityBase(Consumer<Boolean> entityRequestedCallback, Function<Integer, BufferData> readEntityFunction, Runnable entityProcessedRunnable) {
        this.entityRequestedCallback = entityRequestedCallback;
        this.readEntityFunction = readEntityFunction;
        this.entityProcessedRunnable = new EntityProcessedRunnable(entityProcessedRunnable, this.entityProcessed);
    }

    public static ReadableEntity empty() {
        return EMPTY;
    }

    @Override
    public InputStream inputStream() {
        if (this.consumed.compareAndSet(false, true)) {
            if (!this.entityRequested.getAndSet(true)) {
                this.entityRequestedCallback.accept(false);
            }
            this.inputStream = new RequestingInputStream(this.readEntityFunction, this.entityProcessedRunnable);
            return this.inputStream;
        }
        throw new IllegalStateException("Entity has already been requested. Entity cannot be requested multiple times");
    }

    @Override
    public <T> T as(Class<T> type) {
        if (InputStream.class.equals(type)) {
            return (T)this.inputStream();
        }
        if (byte[].class.equals(type)) {
            return (T)this.readAllBytes();
        }
        if (String.class.equals(type)) {
            return this.as(GenericType.STRING);
        }
        return this.as(GenericType.create(type));
    }

    @Override
    public final <T> T as(GenericType<T> type) {
        return this.entityAs(type);
    }

    @Override
    public <T> Optional<T> asOptional(GenericType<T> type) {
        if (this.hasEntity()) {
            return Optional.of(this.entityAs(type));
        }
        return Optional.empty();
    }

    @Override
    public boolean consumed() {
        return this.entityProcessed.get();
    }

    @Override
    public void consume() {
        if (this.consumed()) {
            return;
        }
        if (!this.entityRequested.getAndSet(true)) {
            this.entityRequestedCallback.accept(true);
        }
        InputStream theStream = this.inputStream == null ? this.inputStream() : this.inputStream;
        try (InputStream inputStream = theStream;){
            byte[] buffer = new byte[2048];
            while (theStream.read(buffer) > 0) {
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean hasEntity() {
        return true;
    }

    protected abstract <T> T entityAs(GenericType<T> var1);

    protected byte[] readAllBytes() {
        try {
            return this.inputStream().readAllBytes();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected Function<Integer, BufferData> readEntityFunction() {
        return this.readEntityFunction;
    }

    protected Runnable entityProcessedRunnable() {
        return this.entityProcessedRunnable;
    }

    private static class EntityProcessedRunnable
    implements Runnable {
        private final Runnable original;
        private final AtomicBoolean finishedReading;

        EntityProcessedRunnable(Runnable original, AtomicBoolean finishedReading) {
            this.original = original;
            this.finishedReading = finishedReading;
        }

        @Override
        public void run() {
            this.finishedReading.set(true);
            this.original.run();
        }
    }

    private static class RequestingInputStream
    extends InputStream {
        private final Function<Integer, BufferData> bufferFunction;
        private final Runnable entityProcessedRunnable;
        private BufferData currentBuffer;
        private boolean finished;

        private RequestingInputStream(Function<Integer, BufferData> bufferFunction, Runnable entityProcessedRunnable) {
            this.bufferFunction = bufferFunction;
            this.entityProcessedRunnable = entityProcessedRunnable;
        }

        @Override
        public int read() throws IOException {
            if (this.finished) {
                return -1;
            }
            this.ensureBuffer(512);
            if (this.finished || this.currentBuffer == null) {
                return -1;
            }
            return this.currentBuffer.read();
        }

        @Override
        public void close() throws IOException {
            if (!this.finished) {
                this.ensureBuffer(1);
            }
        }

        @Override
        public int read(byte[] b, int off, int len) {
            if (this.finished) {
                return -1;
            }
            this.ensureBuffer(len);
            if (this.finished || this.currentBuffer == null) {
                return -1;
            }
            return this.currentBuffer.read(b, off, len);
        }

        private void ensureBuffer(int estimate) {
            if (this.currentBuffer != null && this.currentBuffer.consumed()) {
                this.currentBuffer = null;
            }
            if (this.currentBuffer == null) {
                this.currentBuffer = this.bufferFunction.apply(estimate);
                if (this.currentBuffer == null || this.currentBuffer == BufferData.empty()) {
                    this.entityProcessedRunnable.run();
                    this.finished = true;
                }
            }
        }
    }

    private static final class EmptyReadableEntity
    implements ReadableEntity {
        private EmptyReadableEntity() {
        }

        @Override
        public InputStream inputStream() {
            return new ByteArrayInputStream(BufferData.EMPTY_BYTES);
        }

        @Override
        public <T> T as(Class<T> type) {
            throw new IllegalStateException("No entity");
        }

        @Override
        public <T> T as(GenericType<T> type) {
            throw new IllegalStateException("No entity");
        }

        @Override
        public <T> Optional<T> asOptional(GenericType<T> type) {
            return Optional.empty();
        }

        @Override
        public boolean consumed() {
            return true;
        }

        @Override
        public ReadableEntity copy(Runnable entityProcessedRunnable) {
            entityProcessedRunnable.run();
            return this;
        }

        @Override
        public boolean hasEntity() {
            return false;
        }
    }
}

