/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.gas;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.CanonicalDispatchPrices;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.TinybarValues;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.ToLongBiFunction;

public class SystemContractGasCalculator {
    private static final long FIXED_VIEW_GAS_COST = 100L;
    private static final long FIXED_TINY_CENT_GAS_PRICE_COST = 852000L;
    private final TinybarValues tinybarValues;
    private final CanonicalDispatchPrices dispatchPrices;
    private final ToLongBiFunction<TransactionBody, AccountID> feeCalculator;

    public SystemContractGasCalculator(@NonNull TinybarValues tinybarValues, @NonNull CanonicalDispatchPrices dispatchPrices, @NonNull ToLongBiFunction<TransactionBody, AccountID> feeCalculator) {
        this.tinybarValues = Objects.requireNonNull(tinybarValues);
        this.dispatchPrices = Objects.requireNonNull(dispatchPrices);
        this.feeCalculator = Objects.requireNonNull(feeCalculator);
    }

    public long gasRequirement(@NonNull TransactionBody body, @NonNull DispatchType dispatchType, @NonNull AccountID payer) {
        Objects.requireNonNull(body);
        Objects.requireNonNull(dispatchType);
        Objects.requireNonNull(payer);
        return this.gasRequirementWithTinycents(body, payer, this.dispatchPrices.canonicalPriceInTinycents(dispatchType));
    }

    public long gasRequirementWithTinycents(@NonNull TransactionBody body, @NonNull AccountID payer, long minimumPriceInTinycents) {
        long computedPriceInTinybars = this.feeCalculator.applyAsLong(body, payer);
        long priceInTinycents = Math.max(minimumPriceInTinycents, this.tinybarValues.asTinycents(computedPriceInTinybars));
        return this.gasRequirementFromTinycents(priceInTinycents, this.tinybarValues.childTransactionTinycentGasPrice());
    }

    public long topLevelGasPriceInTinyBars() {
        return this.tinybarValues.topLevelTinybarGasPriceFullPrecision();
    }

    public long viewGasRequirement() {
        long gasRequirement = this.gasRequirementFromTinycents(this.dispatchPrices.canonicalPriceInTinycents(DispatchType.TOKEN_INFO), 852000L);
        return Math.max(100L, gasRequirement);
    }

    public long canonicalGasRequirement(@NonNull DispatchType dispatchType) {
        return this.gasRequirementFromTinycents(this.dispatchPrices.canonicalPriceInTinycents(dispatchType), this.tinybarValues.childTransactionTinycentGasPrice());
    }

    public long canonicalPriceInTinycents(@NonNull DispatchType dispatchType) {
        Objects.requireNonNull(dispatchType);
        return this.dispatchPrices.canonicalPriceInTinycents(dispatchType);
    }

    public long feeCalculatorPriceInTinyBars(@NonNull TransactionBody body, @NonNull AccountID payer) {
        return this.feeCalculator.applyAsLong(body, payer);
    }

    public long gasCostInTinybars(long gas) {
        return gas * this.tinybarValues.childTransactionTinybarGasPrice();
    }

    private long gasRequirementFromTinycents(long tinycentsPrice, long gasPriceInCents) {
        long gasRequirement = (tinycentsPrice + gasPriceInCents - 1L) * 1000L / gasPriceInCents;
        return gasRequirement + gasRequirement / 5L;
    }
}

