/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.schedulecall;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.contract.ContractCallTransactionBody;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.scheduled.ScheduleCreateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.HssCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.schedulecall.ScheduleCallTranslator;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ScheduleCallDecoder {
    @Inject
    public ScheduleCallDecoder() {
    }

    public TransactionBody decodeScheduleCall(@NonNull HssCallAttempt attempt, @NonNull Set<Key> keys) {
        boolean waitForExpiry;
        AccountID payer;
        Address to;
        Tuple call;
        int paramIndex = 0;
        if (attempt.isSelector(ScheduleCallTranslator.SCHEDULE_CALL)) {
            call = ScheduleCallTranslator.SCHEDULE_CALL.decodeCall(attempt.inputBytes());
            to = (Address)call.get(paramIndex++);
            payer = attempt.senderId();
            waitForExpiry = true;
        } else if (attempt.isSelector(ScheduleCallTranslator.SCHEDULE_CALL_WITH_PAYER)) {
            call = ScheduleCallTranslator.SCHEDULE_CALL_WITH_PAYER.decodeCall(attempt.inputBytes());
            to = (Address)call.get(paramIndex++);
            payer = attempt.addressIdConverter().convert((Address)call.get(paramIndex++));
            waitForExpiry = true;
        } else if (attempt.isSelector(ScheduleCallTranslator.EXECUTE_CALL_ON_PAYER_SIGNATURE)) {
            call = ScheduleCallTranslator.EXECUTE_CALL_ON_PAYER_SIGNATURE.decodeCall(attempt.inputBytes());
            to = (Address)call.get(paramIndex++);
            payer = attempt.addressIdConverter().convert((Address)call.get(paramIndex++));
            waitForExpiry = false;
        } else {
            throw new IllegalStateException("Unexpected function selector");
        }
        long expirySecond = ConversionUtils.asLongLimitedToZeroOrMax((BigInteger)call.get(paramIndex++));
        long gasLimit = ConversionUtils.asLongLimitedToZeroOrMax((BigInteger)call.get(paramIndex++));
        long value = ConversionUtils.asLongLimitedToZeroOrMax((BigInteger)call.get(paramIndex++));
        byte[] callData = (byte[])call.get(paramIndex);
        ContractID contractId = ConversionUtils.asContractId(attempt.enhancement().nativeOperations().entityIdFactory(), ConversionUtils.fromHeadlongAddress(to));
        return this.transactionBodyFor(attempt, this.scheduleCreateTransactionBodyFor(this.scheduledTransactionBodyFor(contractId, gasLimit, value, callData), keys, expirySecond, payer, waitForExpiry));
    }

    @VisibleForTesting
    public TransactionBody transactionBodyFor(@NonNull HssCallAttempt attempt, @NonNull ScheduleCreateTransactionBody scheduleCreateTrx) {
        return TransactionBody.newBuilder().transactionID(attempt.enhancement().nativeOperations().getTransactionID()).scheduleCreate(scheduleCreateTrx).build();
    }

    @VisibleForTesting
    public ScheduleCreateTransactionBody scheduleCreateTransactionBodyFor(@NonNull SchedulableTransactionBody scheduleTrx, @NonNull Set<Key> keys, long expirySecond, @NonNull AccountID payer, boolean waitForExpiry) {
        Objects.requireNonNull(scheduleTrx);
        Objects.requireNonNull(keys);
        Objects.requireNonNull(payer);
        return ScheduleCreateTransactionBody.newBuilder().scheduledTransactionBody(scheduleTrx).adminKey((Key)keys.stream().findFirst().orElse(null)).expirationTime(Timestamp.newBuilder().seconds(expirySecond)).payerAccountID(payer).waitForExpiry(waitForExpiry).build();
    }

    @VisibleForTesting
    public SchedulableTransactionBody scheduledTransactionBodyFor(@NonNull ContractID contractId, long gasLimit, long value, @NonNull byte[] callData) {
        Objects.requireNonNull(contractId);
        Objects.requireNonNull(callData);
        return SchedulableTransactionBody.newBuilder().contractCall(ContractCallTransactionBody.newBuilder().contractID(contractId).gas(gasLimit).amount(value).functionParameters(Bytes.wrap((byte[])callData))).build();
    }
}

