/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.schedulenative;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.scheduled.ScheduleCreateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.DispatchForResponseCodeHssCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallFactory;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.node.app.spi.workflows.DispatchOptions;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Set;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class ScheduleNativeCall
extends AbstractCall {
    private final ContractID contractID;
    private final VerificationStrategy verificationStrategy;
    private final AccountID payerID;
    private final DispatchGasCalculator dispatchGasCalculator;
    private final Set<Key> authorizingKeys;
    private final Bytes innerCallData;
    private final boolean waitForExpiry;
    private final HtsCallFactory htsCallFactory;

    public ScheduleNativeCall(@NonNull ContractID contractID, @NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull VerificationStrategy verificationStrategy, @NonNull AccountID payerID, @NonNull DispatchGasCalculator dispatchGasCalculator, @NonNull Set<Key> authorizingKeys, @NonNull Bytes innerCallData, @NonNull HtsCallFactory htsCallFactory, boolean waitForExpiry) {
        super(gasCalculator, enhancement, false);
        this.contractID = Objects.requireNonNull(contractID);
        this.verificationStrategy = Objects.requireNonNull(verificationStrategy);
        this.payerID = Objects.requireNonNull(payerID);
        this.dispatchGasCalculator = Objects.requireNonNull(dispatchGasCalculator);
        this.authorizingKeys = authorizingKeys;
        this.innerCallData = Objects.requireNonNull(innerCallData);
        this.htsCallFactory = Objects.requireNonNull(htsCallFactory);
        this.waitForExpiry = waitForExpiry;
    }

    @Override
    @NonNull
    public Call.PricedResult execute(@NonNull MessageFrame frame) {
        HtsCallAttempt nativeAttempt = this.htsCallFactory.createCallAttemptFrom(this.contractID, this.innerCallData, FrameUtils.CallType.DIRECT_OR_PROXY_REDIRECT, frame);
        Call call = Objects.requireNonNull(nativeAttempt.asExecutableCall());
        SchedulableTransactionBody scheduleTransactionBody = call.asSchedulableDispatchIn();
        TransactionBody scheduleCreateTransactionBody = this.bodyForScheduleCreate(scheduleTransactionBody);
        long gasRequirement = this.dispatchGasCalculator.gasRequirement(scheduleCreateTransactionBody, this.gasCalculator, this.enhancement, this.payerID);
        ContractCallStreamBuilder recordBuilder = this.systemContractOperations().dispatch(scheduleCreateTransactionBody, this.verificationStrategy, this.payerID, ContractCallStreamBuilder.class, this.authorizingKeys, DispatchOptions.UsePresetTxnId.YES);
        ResponseCodeEnum status = recordBuilder.status();
        if (status != ResponseCodeEnum.SUCCESS) {
            return Call.PricedResult.gasOnly(FullResult.revertResult(status, gasRequirement), status, this.isViewCall);
        }
        return Call.PricedResult.gasOnly(FullResult.successResult(DispatchForResponseCodeHssCall.scheduleCreateResultEncode(recordBuilder), gasRequirement, recordBuilder), status, this.isViewCall);
    }

    @NonNull
    private TransactionBody bodyForScheduleCreate(SchedulableTransactionBody scheduleTransactionBody) {
        return TransactionBody.newBuilder().transactionID(this.nativeOperations().getTransactionID()).scheduleCreate(ScheduleCreateTransactionBody.newBuilder().scheduledTransactionBody(scheduleTransactionBody).payerAccountID(this.payerID).waitForExpiry(this.waitForExpiry)).build();
    }
}

