/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.fungibletokeninfo.address_0x16c;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HtsSystemContract;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.fungibletokeninfo.FungibleTokenInfoCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class FungibleTokenInfoTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod FUNGIBLE_TOKEN_INFO_16C = SystemContractMethod.declare("getFungibleTokenInfo(address)", "(int32,(((string,string,address,string,bool,int64,bool,(uint256,(bool,address,bytes,bytes,address))[],(int64,address,int64),bytes),int64,bool,bool,bool,(uint32,address,bool,bool,address)[],(uint32,uint32,uint32,uint32,bool,address)[],(uint32,uint32,uint32,address,bool,address)[],string),int32))").withVariants(SystemContractMethod.Variant.V2, SystemContractMethod.Variant.FT).withSupportedAddress(HtsSystemContract.HTS_16C_CONTRACT_ID).withCategory(SystemContractMethod.Category.TOKEN_QUERY);

    @Inject
    public FungibleTokenInfoTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(FUNGIBLE_TOKEN_INFO_16C);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isMethod(FUNGIBLE_TOKEN_INFO_16C);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        Tuple args = FUNGIBLE_TOKEN_INFO_16C.decodeCall(attempt.input().toArrayUnsafe());
        Token token = attempt.linkedToken(ConversionUtils.fromHeadlongAddress((Address)args.get(0)));
        return new FungibleTokenInfoCall(attempt.systemContractGasCalculator(), attempt.enhancement(), attempt.isStaticCall(), token, attempt.configuration(), FUNGIBLE_TOKEN_INFO_16C.function());
    }
}

