/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.isassociated;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AbstractRevertibleTokenViewCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.isassociated.IsAssociatedTranslator;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class IsAssociatedCall
extends AbstractRevertibleTokenViewCall {
    private final AccountID sender;

    public IsAssociatedCall(@NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID sender, @NonNull Token token) {
        super(systemContractGasCalculator, enhancement, token);
        this.sender = sender;
    }

    @Override
    @NonNull
    protected Call.PricedResult resultOfViewingToken(@NonNull Token token) {
        Objects.requireNonNull(token);
        TokenRelation tokenRel = this.nativeOperations().getTokenRelation(this.nativeOperations().entityIdFactory().newAccountId(this.sender.accountNum().longValue()), this.nativeOperations().entityIdFactory().newTokenId(token.tokenIdOrThrow().tokenNum()));
        boolean result = tokenRel != null;
        return Call.PricedResult.gasOnly(FullResult.successResult(IsAssociatedTranslator.IS_ASSOCIATED.getOutputs().encode((Object)Tuple.singleton((Object)result)), this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.SUCCESS, true);
    }
}

