/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.isfrozen;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AbstractNonRevertibleTokenViewCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.defaultfreezestatus.DefaultFreezeStatusTranslator;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class IsFrozenCall
extends AbstractNonRevertibleTokenViewCall {
    private final Address account;
    private final boolean isStaticCall;

    public IsFrozenCall(@NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, boolean isStaticCall, @Nullable Token token, @NonNull Address account) {
        super(gasCalculator, enhancement, token);
        this.account = Objects.requireNonNull(account);
        this.isStaticCall = isStaticCall;
    }

    @Override
    @NonNull
    protected Call.PricedResult resultOfViewingToken(@NonNull Token token) {
        Objects.requireNonNull(token);
        long accountNum = ConversionUtils.accountNumberForEvmReference(this.account, this.nativeOperations());
        if (accountNum < 0L) {
            return Call.PricedResult.gasOnly(this.fullResultsFor(ResponseCodeEnum.INVALID_ACCOUNT_ID, this.gasCalculator.viewGasRequirement(), false), ResponseCodeEnum.INVALID_ACCOUNT_ID, true);
        }
        TokenRelation tokenRel = this.nativeOperations().getTokenRelation(this.nativeOperations().entityIdFactory().newAccountId(accountNum), this.nativeOperations().entityIdFactory().newTokenId(token.tokenIdOrThrow().tokenNum()));
        boolean result = tokenRel != null && tokenRel.frozen();
        return Call.PricedResult.gasOnly(this.fullResultsFor(ResponseCodeEnum.SUCCESS, this.gasCalculator.viewGasRequirement(), result), ResponseCodeEnum.SUCCESS, true);
    }

    @Override
    @NonNull
    protected FullResult viewCallResultWith(@NonNull ResponseCodeEnum status, long gasRequirement) {
        return this.fullResultsFor(status, gasRequirement, false);
    }

    @NonNull
    private FullResult fullResultsFor(@NonNull ResponseCodeEnum status, long gasRequirement, boolean isFrozen) {
        if (this.isStaticCall && status != ResponseCodeEnum.SUCCESS) {
            return FullResult.revertResult(status, gasRequirement);
        }
        return FullResult.successResult(DefaultFreezeStatusTranslator.DEFAULT_FREEZE_STATUS.getOutputs().encode((Object)Tuple.of((Object)status.protoOrdinal(), (Object)isFrozen)), gasRequirement);
    }
}

