/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.update.address_0x167;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.token.TokenUpdateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.update.UpdateCommonDecoder;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.update.UpdateExpiryTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.update.address_0x167.UpdateKeysTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.update.address_0x167.UpdateTranslator;
import com.hedera.node.app.service.contract.impl.exec.utils.TokenExpiryWrapper;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class UpdateDecoder
extends UpdateCommonDecoder {
    @Inject
    public UpdateDecoder() {
    }

    @Nullable
    public TransactionBody decodeTokenUpdateV1(@NonNull HtsCallAttempt attempt) {
        Tuple call = UpdateTranslator.TOKEN_UPDATE_INFO_FUNCTION_V1.decodeCall(attempt.input().toArrayUnsafe());
        TokenUpdateTransactionBody.Builder decoded = this.decodeTokenUpdate(call, attempt.addressIdConverter(), attempt.nativeOperations());
        return TransactionBody.newBuilder().tokenUpdate(decoded).build();
    }

    @Nullable
    public TransactionBody decodeTokenUpdateV2(@NonNull HtsCallAttempt attempt) {
        Tuple call = UpdateTranslator.TOKEN_UPDATE_INFO_FUNCTION_V2.decodeCall(attempt.input().toArrayUnsafe());
        TokenUpdateTransactionBody.Builder decoded = this.decodeTokenUpdate(call, attempt.addressIdConverter(), attempt.nativeOperations());
        return TransactionBody.newBuilder().tokenUpdate(decoded).build();
    }

    @Nullable
    public TransactionBody decodeTokenUpdateV3(@NonNull HtsCallAttempt attempt) {
        Tuple call = UpdateTranslator.TOKEN_UPDATE_INFO_FUNCTION_V3.decodeCall(attempt.input().toArrayUnsafe());
        TokenUpdateTransactionBody.Builder decoded = this.decodeTokenUpdate(call, attempt.addressIdConverter(), attempt.nativeOperations());
        return TransactionBody.newBuilder().tokenUpdate(decoded).build();
    }

    public TransactionBody decodeTokenUpdateExpiryV1(@NonNull HtsCallAttempt attempt) {
        Tuple call = UpdateExpiryTranslator.UPDATE_TOKEN_EXPIRY_INFO_V1.decodeCall(attempt.input().toArrayUnsafe());
        return this.decodeTokenUpdateExpiry(call, attempt);
    }

    public TransactionBody decodeTokenUpdateExpiryV2(@NonNull HtsCallAttempt attempt) {
        Tuple call = UpdateExpiryTranslator.UPDATE_TOKEN_EXPIRY_INFO_V2.decodeCall(attempt.input().toArrayUnsafe());
        return this.decodeTokenUpdateExpiry(call, attempt);
    }

    @Override
    protected Tuple decodeCall(@NonNull HtsCallAttempt attempt) {
        return UpdateKeysTranslator.TOKEN_UPDATE_KEYS_FUNCTION.decodeCall(attempt.input().toArrayUnsafe());
    }

    private TransactionBody decodeTokenUpdateExpiry(@NonNull Tuple call, @NonNull HtsCallAttempt attempt) {
        Address tokenId = (Address)call.get(0);
        Tuple expiryTuple = (Tuple)call.get(1);
        TokenUpdateTransactionBody.Builder txnBodyBuilder = TokenUpdateTransactionBody.newBuilder();
        txnBodyBuilder.token(ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), tokenId));
        TokenExpiryWrapper tokenExpiry = this.decodeTokenExpiry(expiryTuple, attempt.addressIdConverter());
        if (tokenExpiry.second() != 0L) {
            txnBodyBuilder.expiry(Timestamp.newBuilder().seconds(tokenExpiry.second()).build());
        }
        if (tokenExpiry.autoRenewAccount() != null) {
            txnBodyBuilder.autoRenewAccount(tokenExpiry.autoRenewAccount());
        }
        if (tokenExpiry.autoRenewPeriod() != null && tokenExpiry.autoRenewPeriod().seconds() != 0L) {
            txnBodyBuilder.autoRenewPeriod(tokenExpiry.autoRenewPeriod());
        }
        return TransactionBody.newBuilder().tokenUpdate(txnBodyBuilder).build();
    }
}

