/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.service.contract.impl.state.AbstractMutableEvmAccount;
import com.hedera.node.app.service.contract.impl.state.EvmFrameState;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;

public abstract class AbstractEvmEntityAccount
extends AbstractMutableEvmAccount {
    public static final long ENTITY_PROXY_ACCOUNT_NONCE = -1L;
    protected final Address address;
    protected final EvmFrameState state;

    protected AbstractEvmEntityAccount(@NonNull Address address, @NonNull EvmFrameState state) {
        this.address = Objects.requireNonNull(address);
        this.state = Objects.requireNonNull(state);
    }

    public Address getAddress() {
        return this.address;
    }

    public long getNonce() {
        return -1L;
    }

    public Wei getBalance() {
        return Wei.ZERO;
    }

    @NonNull
    public UInt256 getStorageValue(@NonNull UInt256 key) {
        return UInt256.ZERO;
    }

    public UInt256 getOriginalStorageValue(@NonNull UInt256 key) {
        return UInt256.ZERO;
    }

    @Override
    public Account toNativeAccount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTokenFacade() {
        return false;
    }

    @Override
    public boolean isScheduleTxnFacade() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public void becomeImmutable() {
        throw new UnsupportedOperationException("Not Implemented Yet");
    }

    public void setNonce(long value) {
        throw new UnsupportedOperationException("setNonce");
    }

    public void setCode(@NonNull Bytes code) {
        throw new UnsupportedOperationException("setCode");
    }

    public void setStorageValue(@NonNull UInt256 key, @NonNull UInt256 value) {
        throw new UnsupportedOperationException("setStorageValue");
    }

    @Override
    public boolean isRegularAccount() {
        return false;
    }

    @Override
    @NonNull
    public AccountID hederaId() {
        throw new IllegalStateException("Entity facade has no usable Hedera id");
    }

    @Override
    @NonNull
    public ContractID hederaContractId() {
        return this.state.entityIdFactory().newContractId(ConversionUtils.numberOfLongZero(this.address));
    }

    public boolean isStorageEmpty() {
        return true;
    }
}

